<?php
class emailmarketing{
	function __construct() {
		if (!allow_access(3)) {
			return_err('access denied');
		}
		set_title('Email Marketing');
		nav(url('emailmarketing','Email Marketing'));
	}
	function index() {
		c('<h2>Email Marketing</h2>
		<h5>Recepts</h5>');
		$res = sql_query("select count(*) as num from jcow_edm_recipients");
		$row = sql_fetch_array($res);
		c('You have <a href="'.url('emailmarketing/recipients').'"><strong>'.$row['num'].'</strong> recipients</a>.
			<p>'.button(['type'=>'link','title'=>'Import from text','uri'=>'emailmarketing/import_from_text']).
			button(['type'=>'link','title'=>'Import from community members','uri'=>'emailmarketing/import_from_community']).'</p>');
		c('<h5>Messages</h5>
		<table class="table"><tr><th>title</th><th>sent</th><th>operation</th></tr>');
		$res = sql_query("select * from jcow_edm_ads order by id desc limit 100");
		while ($row = sql_fetch_array($res)) {
			c('<tr>
				<td><a href="'.url('emailmarketing/message/'.$row['id']).'">'.h($row['title']).'</a></td>
				<td>'.$row['sent'].'</td>
				<td>'.url('emailmarketing/message/'.$row['id'].'/delete','Delete').' '.url('emailmarketing/message/'.$row['id'].'/edit','Edit').'</td>
				</tr>');
		}
		c('</table>
		<h5>Create new message</h5>
		<form action="'.url('emailmarketing/newmessage').'" method="post" class="ajaxform">
			<div class="form-group"><label>Title</label><input type="text" name="title" placeholder="Email Title" class="form-control" /></div>
			'.input(['type'=>'richtextarea','label'=>'Body', 'placeholder'=>'Body', 'name'=>'form_content', 'value'=> '' ]).'
			<p><input type="submit" class="btn btn-primary" value="Create" /></p></form>
		');
	}

	function recipients() {
		nav('recipients');
		c('<h5>Recipients</h5>
			<form method="post" action="'.url('emailmarketing/recipients').'">
			<input type="text" name="email" /> <input type="submit" value="Search" />
			</form>');
		if ($_POST['email']) {
			$res = sql_query("select * from jcow_edm_recipients where email like '%".$_POST['email']."%' limit 10");
		}	
		else {
			$res = sql_query("select * from jcow_edm_recipients order by id desc limit 100");
		}
		while ($email = sql_fetch_array($res)) {
			c('<div>');
			if ($email['ignored']) {
				c( '<span style="color:red">'.$email['email'].'</span>'.
					button([
						'title'=>'un-ignore',
						'uri'=>'emailmarketing/unignore/'.$email['id'],
						'post_title'=>'done'
					])
				);
			}
			else {
				c( 
					$email['email'].
					button([
						'title'=>'ignore',
						'uri'=>'emailmarketing/ignore/'.$email['id'],
						'post_title'=>'done'
					])
				);
			}
			c('</div>');
		}
	}

	function ignore($id) {
		sql_query("update jcow_edm_recipients set ignored=true where id='$id'");
		return_ok();
	}

	function unignore($id) {
		sql_query("update jcow_edm_recipients set ignored=false where id='$id'");
		return_ok();
	}

	function import_from_community() {
		c('<h5>Import Email addresses from community members</h5>');
		$res = sql_query("select count(*) as num from jcow_accounts");
		$row = sql_fetch_array($res);
		c('<p>You have <strong>'.$row['num'].'</strong> members.</p>
			<form action="'.url('emailmarketing/import_from_community_post').'" method="post" class="ajaxform">
			<input type="checkbox" name="filter" value="yes" checked /> Filter fake Emails.
			<p><input type="submit" class="btn btn-primary" value="Start Importing" /></p></form>');
	}

	function import_from_community_post() {
		$emails = [];
		$res = sql_query("select * from jcow_accounts order by id desc limit 1000");
		while ($row = sql_fetch_array($res)) {
			$emails[] = $row['email'];
		}
		if ($_POST['filter'] == 'yes') {
			$emails = email_filter($emails);
		}
		foreach ($emails as $email) {
			$res = sql_query("select * from jcow_edm_recipients where email='$email'");
			if (!sql_counts($res)) {
				sql_query("insert into jcow_edm_recipients(email,code) values('$email','".get_rand(15)."')");
			}
		}
		return_go('emailmarketing');
	}

	function import_from_text() {
		c('<h5>Import Email addresses from Text</h5>
			(Separate multiple Emails by line breaks)
			<form action="'.url('emailmarketing/import_from_text_post').'" method="post" class="ajaxform">
			<div class="form-group">
				<textarea name="emails" class="form-control" rows="15" placeholder="email1@exaple.com&#10;email2@exaple.com&#10;email3@exaple.com&#10;etc.. "></textarea>
			</div>
			<input type="checkbox" name="filter" value="yes" checked /> Filter fake Emails.
			<p><input type="submit" class="btn btn-primary" value="Import" /></p></form>');
	}

	function import_from_text_post() {
		if (!$_POST['emails']) {
			return_err('no emails');
		}
		$rows = explode(PHP_EOL, $_POST['emails']);
		$emails = [];
		foreach ($rows as $email) {
			$email = trim($email);
			if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
				$emails[] = $email;
			}
		}
		if ($_POST['filter'] == 'yes') {
			$emails = email_filter($emails);
		}
		foreach ($emails as $email) {
			$res = sql_query("select * from jcow_edm_recipients where email='$email'");
			if (!sql_counts($res)) {
				sql_query("insert into jcow_edm_recipients(email,code) values('$email','".get_rand(15)."')");
			}
		}
		return_go('emailmarketing');
	}

	function message($id, $act='') {
		nav('Message');
		$res = sql_query("select * from jcow_edm_ads where id='$id'");
		$message = sql_fetch_array($res);
		if (!$message['id']) die('message not found');
		if ($act == 'edit') {
			c('<h5>Edit Message</h5>
				<form action="'.url('emailmarketing/editmessage').'" method="post" class="ajaxform">
			<div class="form-group"><label>Title</label><input type="text" name="title" placeholder="Email Title" class="form-control" value="'.h($message['title']).'" /></div>
			'.input(['type'=>'richtextarea','label'=>'Body', 'placeholder'=>'Body', 'name'=>'form_content', 'value'=> $message['body'] ]).'
			<input type="hidden" name="mid" value="'.$message['id'].'" />
			<p><input type="submit" class="btn btn-primary" value="Save changes" /></p></form>');
			stop_here();
		}
		if ($act == 'delete') {
			sql_query("delete from jcow_edm_ads where id='{$message['id']}'");
			redirect('emailmarketing');
		}
		$res = sql_query("select count(*) as num from jcow_edm_recipients where id > ".$message['last_email_id']);
		$row = sql_fetch_array($res);
		c('<p>There are <strong>'.$row['num'].'</strong> recipients to send.</p>');
		if ($row['num'] > 0) {
			c('
			<script>
			$(function() {
				var total_num = 0;
				$("#send_edm_btn").on("click",function() {
					$(this).hide();
					$("#edm_monitor_sending").show();
					$("#edm_monitor").show();
					setTimeout(send_edm,1000);
				});

				function send_edm() {
					var formData = new FormData();
					$.ajax({
				        url: "'.url('emailmarketing/sending_edm/'.$message['id']).'",
				        type: "POST",
				        data: formData,
				        async: false,
				        cache: false,
				        dataType: "json",
				        processData: false,
				        contentType: false,
				        async: true,
				        success: function (data) {
				        	total_num = total_num + data.sent;
				        	$("#edm_monitor_sent").html(total_num);
				        	console.log("data:",data);
				        	if (!data.finished) {
				        		$("#edm_monitor_emails").html(data.emails);
				        		setTimeout(send_edm,1000);
				        	}
				        	else {
				        		$("#edm_monitor_sending").hide();
				        		$("#edm_monitor_finished").show();
				        	}
				        }
				    });
				}
			});
			</script>
			<p><button id="send_edm_btn">Start Sending Emails</button></p>
			<div id="edm_monitor" style="display:none;padding:10px;background:#eee">
				<div id="edm_monitor_sending"><i class="fa fa-refresh fa-spin fa-3x fa-fw"></i> Sending Emails. Please do not close this window.<div id="edm_monitor_emails"></div> </div>
				<div id="edm_monitor_finished" style="display:none;font-weight:bold">Finished!</div>
				<div>Total <span id="edm_monitor_sent" style="font-weight:bold">0</span> sent.</div>

			</div> ');
		}
		c('<p>Title: '.h($message['title']).'</p>
			<p>Body:'.$message['body'].'</p>
			');
	}

	function sending_edm($id) {
		$res = sql_query("select * from jcow_edm_ads where id='$id'");
		$ads = sql_fetch_array($res);
		if (!$ads['id']) {
			return_err('no found');
		}
		$num = 0;
		$emails = [];
		$res = sql_query("select * from jcow_edm_recipients where id>".$ads['last_email_id']." order by id asc limit 5");
		if (!sql_counts($res)) {
			return_ok(['finished'=>true,'sent'=>0]);
		}
		while ($recipient = sql_fetch_array($res)) {
			if (!$recipient['ignored']) {
				$num++;
				$emails[] = $recipient['email'];
				// send mail
				$ads['body'] = str_replace('uploads/userfiles',uhome().'/uploads/userfiles',$ads['body']);
				jcow_mail($recipient['email'],$ads['title'],$ads['body'],'',[
					'unsubscribe_content'=>'<div style="color:#bfbfbf;font-size:12px">This email was sent by '.get_gvar('site_name').'.
If you don\'t want to receive this type of email in the future, please <a href="'.uhome().'/index.php?act=emunsubscribe&id='.$recipient['id'].'&code='.$recipient['code'].'" style="color:#bfbfbf">unsubscribe</a>.</div>'
				]);
			}
			sql_query("update jcow_edm_ads set last_email_id={$recipient['id']},sent=sent+$num where id={$ads['id']} ");
		}
		return_ok([
			'sent'=>$num,
			'emails'=>implode(',',$emails)
		]);

	}
	function editmessage() {
		if (!$_POST['title'] || !$_POST['form_content']) {
			return_err('no title or body ');
		}
		sql_query("update jcow_edm_ads set title='".safe($_POST['title'])."', body='".safe($_POST['form_content'])."' where id='{$_POST['mid']}'");
		return_go('emailmarketing');
	}

	function newmessage() {
		if (!$_POST['title'] || !$_POST['form_content']) {
			return_err('no title or body ');
		}
		sql_query("insert into jcow_edm_ads(title,body) values('".safe($_POST['title'])."','".safe($_POST['form_content'])."')");
		return_go('emailmarketing');
	}
}

function email_filter($emails) {
	$newrow = [];
	foreach ($emails as $email) {
		$arr = explode('@',$email);
		if (substr_count($arr[0],'.') > 2 || preg_match("/(test)|(adsf)|(asdf)/i",$email) ) {

		}
		else {
			$newrow[] = $email;
		}
	}
	return $newrow;
}