<?php
/* ############################################################ *\
 ----------------------------------------------------------------
@package	Jcow Social Networking Script.
@copyright	Copyright (C) 2009 - 2010 jcow.net.  All Rights Reserved.
@license	see http://jcow.net/license
 ----------------------------------------------------------------
\* ############################################################ */


class catalog extends story{
	var $categories = array();
	function __construct() {
		$this->tags = false;
		$this->plain_content = true;
		$this->enable_category = true;
		if (allow_access(3)) {
			$this->redirect_writestorypost = url('catalog');
		}
		else {
			$this->redirect_writestorypost = url('catalog/pending');
		}
		$this->label_content = 'Description';
		$res = sql_query("select * from jcow_story_categories where ".sa()." app='catalog' and gid=0 order by weight");
		while ($row = sql_fetch_array($res)) {
			$this->categories[] = $row;
		}
		c('<style>
			.category_group {
				min-width:250px;
				margin:10px;
			}
			.category_name {
				font-size:20px;
			}
			.category_sub_name {
				display:inline-block;
				margin:5px 10px 0 0;
			}
			.catalog_box {
				margin:30px 0;
			}
			.catalog_title {
				font-size:25px;
			}
			.catalog_link {

			}
			</style>');
	}
	function index() {
		global $client;
		c('<div>');
		if ($client['id'] && count($this->categories) ) {
			c('<a href="'.url('catalog/writestory').'" class="jcow-btn jcow-btn-default">Add Listing</a>');
		}
		if (allow_access(3)) {
			$res = sql_query("select count(*) as num from jcow_stories where ".sa()." app='catalog' and var5='pending'");
			$row = sql_fetch_array($res);
			c('<a href="'.url('catalog/manage_categories').'" class="jcow-btn jcow-btn-default">Manage Categoires</a>
				<a href="'.url('catalog/pending').'" class="jcow-btn jcow-btn-default">Pending submissions ('.$row['num'].')</a>
				');
		}
		c('</div>');

		if (!count($this->categories)) {
			c('<i>no category</i>');
			stop_here();
		}

		c('<div style="display:flex;flex-wrap:wrap">');
		foreach($this->categories as $category) {
			c('<div class="category_group"><div><a href="'.url('catalog/list/'.$category['uri']).'" class="category_name"><i class="fa fa-folder-o"></i> '.h($category['name']).' ('.$category['var1'].')</a></div>');
				$res = sql_query("select * from jcow_story_categories where gid='{$category['id']}' order by weight");
				while ($row = sql_fetch_array($res)) {
					c('<a href="'.url('catalog/list/'.$category['uri'].'/'.$row['uri']).'" class="category_sub_name"><i class="fa fa-folder-o"></i> '.h($row['name']).' ('.$row['var1'].')</a>');
				}
			c('</div>');
		}
		c('</div>');
	}

	function pending() {
		global $client;
		set_title('pending');
		c('<h2>Pending</h2>');
		if (allow_access(3)) {
			$res = sql_query("select s.*,u.username,u.fullname,c.name as cname from jcow_stories as s left join jcow_accounts as u on u.id=s.uid left join jcow_story_categories as c on c.id=s.cid where ".sa('s')." s.app='catalog' and s.var5='pending' order by s.id desc limit 100");
		}
		else {
			$res = sql_query("select s.*,u.username,u.fullname,c.name as cname from jcow_stories as s left join jcow_accounts as u on u.id=s.uid left join jcow_story_categories as c on c.id=s.cid where ".sa('s')." s.app='catalog' and s.var5='pending' and s.uid='{$client['id']}' order by s.id desc limit 100");
		}
		while ($story = sql_fetch_array($res)) {
			if (allow_access(3)) {
				$manage_btn = ' <div><a href="'.url('catalog/remove/'.$story['id']).'">Remove</a><br /><a href="'.url('catalog/verify/'.$story['id']).'">Verify</a></div>';
			}
			c('<div class="catalog_box">
					<div style="display:flex;justify-content:space-between"><a href="'.$story['var1'].'" class="catalog_title" target="_blank">'.h($story['title']).'</a>'.$manage_btn.'</div>
					<div><a href="'.$story['var1'].'" class="catalog_link" target="_blank">'.$story['var1'].'</a></div>
					<div>submitted to <strong>'.h($story['cname']).'</strong>, by <a href="'.url('u/'.$story['username']).'">'.h($story['fullname']).'</a></div>
					<div class="catalog_des">'.nl2br(h($story['content'])).'</div></div>');
		}
	}

	function list($category_uri='',$subcategory_uri='') {
		if (preg_match("/^[0-9a-z_]+$/",$category_uri)) {
			$res = sql_query("select * from jcow_story_categories where app='catalog' and uri='$category_uri'");
			$livecat = $cat = sql_fetch_array($res);
			if (!$cat['id']) die('wrong uri');
			$nav = '<a href="'.url('catalog').'">Link Directory</a> / '.h($cat['name']);
			if (preg_match("/^[0-9a-z_]+$/",$subcategory_uri)) {
				$res2 = sql_query("select * from jcow_story_categories where app='catalog' and uri='$subcategory_uri'");
				$livecat = $subcat = sql_fetch_array($res2);
				if (!$subcat['id']) die('wrong uri');
				$nav = '<a href="'.url('catalog').'">Link Directory</a> / <a href="'.url('catalog/list/'.$cat['uri']).'">'.h($cat['name']).'</a> / '.h($subcat['name']);
			}
			set_title($livecat['name']);
			c($nav);
			c('<div style="padding:5px 10px;font-size:30px">'.h($livecat['name']).'</div>');
			if (!$livecat['gid']) {
				c('<div style="padding:0 10px">');
				$res = sql_query("select * from jcow_story_categories where gid='{$livecat['id']}' order by weight");
				while ($row = sql_fetch_array($res)) {
					c('<a href="'.url('catalog/list/'.$livecat['uri'].'/'.$row['uri']).'" class="category_sub_name">'.h($row['name']).' ('.$row['var1'].')</a>');
				}
				c('</div>');
			}
			c('<div style="padding:0 10px">'.nl2br(h($livecat['description'])).'</div>');
			c('<div style="padding:0 10px">'.$livecat['var1'].' links</div>');
			$res = sql_query("select * from jcow_stories where app='catalog' and var5='verified' and cid='{$livecat['id']}' limit 100");

			while ($story = sql_fetch_array($res)) {
				if (allow_access(3)) {
					$remove_btn = ' <a href="'.url('catalog/remove/'.$story['id']).'">Remove</a>';
				}
				c('<div class="catalog_box">
					<div style="display:flex;justify-content:space-between"><a href="'.$story['var1'].'" class="catalog_title" target="_blank"><i class="fa fa-external-link"></i> '.h($story['title']).'</a>'.$remove_btn.'</div>
					<div><a href="'.$story['var1'].'" class="catalog_link" target="_blank">'.$story['var1'].'</a></div>
					<div class="catalog_des">'.nl2br(h($story['content'])).'</div></div>');
			}
			stop_here();
		}
	}

	function remove($sid=0) {
		if (!allow_access(3)) die('access denied');
		$res = sql_query("select * from jcow_stories where id='$sid' and app='catalog' ".esa() );
		$story = sql_fetch_array($res);
		if (!$story['id']) die('not found');
		$res = sql_query("select * from jcow_story_categories where id='{$story['cid']}'");
		$category = sql_fetch_array($res);
		if ($story['var5'] == 'verified') {
			sql_query("update jcow_story_categories set var1=var1-1 where id='{$story['cid']}'");
		}
		sql_query("delete from jcow_stories where id='$sid' and app='catalog' ".esa() );
		redirect('catalog');
	}

	function verify($sid=0) {
		if (!allow_access(3)) die('access denied');
		$res = sql_query("select * from jcow_stories where id='$sid' and app='catalog' ".esa() );
		$story = sql_fetch_array($res);
		if (!$story['id']) die('not found');
		if ($story['var5'] == 'verified') die('already verifed');
		$res = sql_query("select * from jcow_story_categories where id='{$story['cid']}'");
		$category = sql_fetch_array($res);
		sql_query("update jcow_story_categories set var1=var1+1 where id='{$story['cid']}'");
		sql_query("update jcow_stories set var5='verified' where id='$sid' and app='catalog' ".esa() );
		redirect('catalog');
	}

	function hook_writestory($row) {
		$output = '<div class="form-group"><label>URL</label><input type="text" class="form-control" name="url" placeholder="URL" /></div>';
		return $output;
	}

	function hook_writestorypost(&$story) {
		if (!filter_var($_POST['url'], FILTER_VALIDATE_URL)) {
			return_err('Not a valid URL');
		}
		$story['var1'] = $_POST['url'];
		if (allow_access(3)) {
			$story['var5'] = 'verified';
			if ($_POST['cid']) {
				sql_query("update jcow_story_categories set var1=var1+1 where id='{$_POST['cid']}'");
			}
		}
		else {
			$story['var5'] = 'pending';
		}
	}

	function manage_categories($act,$id=0) {
		if (!allow_access(3)) {
			die('access denied');
		}
		if ($act == 'add') {
			if (!$_POST['name']) {
				return_err('No name');
			}
			if (!$_POST['uri']) {
				return_err('No URI');
			}
			$_POST['uri'] = strtolower($_POST['uri']);
			if (!preg_match("/^[0-9a-z_]+$/",$_POST['uri'])) {
				return_err("URI can only contain 0-9a-z_");
			}
			if (!$_POST['cid']) {
				$_POST['cid'] = 0;
			}
			$res = sql_query("select * from jcow_story_categories where ".sa()." app='catalog' and uri='{$_POST['uri']}' and id!='{$_POST['cid']}'");
			if (sql_counts($res)) {
				return_err('Duplicated URI');
			}
			$res = sql_query("select max(weight) as weight from jcow_story_categories where ".sa()." app='catalog'");
			$row = sql_fetch_array($res);
			$weight = $row['weight'] ? ($row['weight'] + 1) : 1;
			$gid = $_POST['gid'] ? $_POST['gid'] : 0;
			$new_cat = [
				'name'=>$_POST['name'],
				'description'=>$_POST['description'],
				'weight'=>$weight,
				'app'=>'catalog',
				'uri'=>$_POST['uri'],
				'var1'=>0,
				'gid'=>$gid
			];
			if ($_POST['cid']) {
				$new_cat['id'] = $_POST['cid'];
				unset($new_cat['gid']);
				sql_update($new_cat, 'jcow_story_categories');
			}
			else {
				sql_insert($new_cat, 'jcow_story_categories');
			}
			if ($gid) {
				return_go('catalog/manage_categories/sub/'.$gid);
			}
			else {
				return_go('catalog/manage_categories');
			}
		}
		elseif ($act == 'delete') {
			sql_query("delete from jcow_story_categories where id='$id' ".esa());
			redirect('catalog/manage_categories');
		}
		elseif ($act == 'edit') {
			$res = sql_query("select * from jcow_story_categories where id='$id' ".esa());
			$cat = sql_fetch_array($res);
			if (!$cat['id']) die('wrong id');
			c('
			<strong>Edit category</strong>
			<form action="'.url('catalog/manage_categories/add').'" method="post" class="ajaxform">
			<p><input type="text" value="'.h($cat['name']).'" name="name" placeholder="Name" class="form-control" /></p>
			<p><input type="text" value="'.h($cat['uri']).'"  name="uri" placeholder="URI (can only contain 0-9a-z)" class="form-control" /></p>
			<p><textarea name="description" placeholder="Description" class="form-control">'.h($cat['description']).'</textarea></p>
			<p><input type="hidden" name="cid" value="'.$cat['id'].'" /><input type="submit" class="btn btn-primary" value="Submit" /></p></form>
			');
		}
		elseif ($act == 'sub') {
			$res = sql_query("select * from jcow_story_categories where id='$id' ".esa());
			$cat = sql_fetch_array($res);
			if (!$cat['id']) die('wrong id');

			c('
				<a href="'.url('catalog').'">Link Directory</a> / <a href="'.url('catalog/manage_categories').'">Categories</a> / <strong>'.h($cat['name']).'</strong>
			<table class="stories">
			<form method="post" action="'.url('catalog/manage_categories/save_weights').'" class="ajaxform">
			<tr class="table_line1"><td>Weight</td><td>Category</td><td>Operation</td></tr>');
			$res = sql_query("select * from jcow_story_categories where ".sa()." gid='{$cat['id']}' order by weight");
			while ($category = sql_fetch_array($res)) {
				c('<tr class="row1">
				<td><input type="text" size="2" name="weights[]" value="'.$category['weight'].'" />
				<input type="hidden" name="categories[]" value="'.$category['id'].'" /></td>
				<td>'.h($category['name']).'</td>
				<td>');
				c(url('catalog/manage_categories/edit/'.$category['id'],'Edit').' | '.url('catalog/manage_categories/delete/'.$category['id'],'Delete').'</td></tr>');
			}
			c('
			<tr class="row1"><td colspan="3"><input type="hidden" name="gid" value="'.$cat['id'].'" /><input type="submit" value="Save Weights" /></td></tr>
			</form></table><br /><br />
			Add a new category under <strong>'.h($cat['name']).'</strong>
			<form action="'.url('catalog/manage_categories/add').'" method="post" class="ajaxform">
			<p><input type="text" name="name" placeholder="Name" class="form-control" /></p>
			<p><input type="text" name="uri" placeholder="URI (can only contain 0-9a-z)" class="form-control" /></p>
			<p><textarea name="description" placeholder="Description" class="form-control"></textarea></p>
			<p><input type="hidden" name="gid" value="'.$cat['id'].'" /><input type="submit" class="btn btn-primary" value="Submit" /></p></form>
			');
		}
		elseif ($act == 'save_weights') {
			if (is_array($_POST['categories'])) {
				foreach ($_POST['categories'] as $key=>$val) {
					$weight = $_POST['weights'][$key];
					sql_query("update jcow_story_categories set weight='$weight' where id='$val' " );
				}
			}
			if ($_POST['gid']) {
				return_go('catalog/manage_categories/sub/'.$_POST['gid']);
			}
			else {
				return_go('catalog/manage_categories');
			}
		}
		else {
			c('
				<a href="'.url('catalog').'">Link Directory</a> / <strong>Categories</strong>
			<table class="stories">
			<form method="post" action="'.url('catalog/manage_categories/save_weights').'" class="ajaxform">
			<tr class="table_line1"><td>Weight</td><td>Category</td><td>Operation</td></tr>');
			foreach ($this->categories as $category) {
				c('<tr class="row1">
				<td><input type="text" size="2" name="weights[]" value="'.$category['weight'].'" />
				<input type="hidden" name="categories[]" value="'.$category['id'].'" /></td>
				<td>'.h($category['name']).'</td>
				<td>');
				if (!$category['cid']) {
					c(url('catalog/manage_categories/sub/'.$category['id'],'Sub categories').' | ');
				}
				c(url('catalog/manage_categories/edit/'.$category['id'],'Edit').' | '.url('catalog/manage_categories/delete/'.$category['id'],'Delete').'</td></tr>');
			}
			c('
			<tr class="row1"><td colspan="3"><input type="submit" value="Save Weights" /></td></tr>
			</form></table><br /><br />
			<strong>Add a new category</strong>
			<form action="'.url('catalog/manage_categories/add').'" method="post" class="ajaxform">
			<p><input type="text" name="name" placeholder="Name" class="form-control" /></p>
			<p><input type="text" name="uri" placeholder="URI (can only contain 0-9a-z)" class="form-control" /></p>
			<p><textarea name="description" placeholder="Description" class="form-control"></textarea></p>
			<p><input type="submit" class="btn btn-primary" value="Submit" /></p></form>
			');

		}
	}
}
