<?php
/* ############################################################ *\
 ----------------------------------------------------------------
@package	jocow community builder.
@copyright	Copyright (C) 2009 jocow.com.  All Rights Reserved.
@license	see http://jocow.com/license
 ----------------------------------------------------------------
\* ############################################################ */

class polls extends story{
	// test1 => select options
	public $list_type = 'ul';
	function polls() {
		global $nav,$ubase;
		$this->hooks(array('writestory','writestorypost','viewstory'));
		$nav[] = url('polls',t('Poll'));
		parent::story();
		$this->label_title = t('Poll question');
		$this->stories_from_cat = t('Lasted polls in this category');
		$this->write_story = t('New poll');	
		$this->allow_vote = $this->who_voted = 0;
		$this->act_write = t('started a poll');
		
	}
	
	function hook_liststories() {
		button($this->name.'/writestory',$this->write_story);
	}

	function hook_writestory($row) {
		$output = '<p>
							'.label(t('Type')).'
								<input type="radio" name="stype" value="0" checked /> '.t('Single selection').
								'<input type="radio" name="stype" value="1" /> '.t('Multiple selection').'
								</p>';
		for($i=1;$i<=10;$i++) {
			$output .= '<p>
			'.label(t('Option').$i).'
			<input type="text" name="opts[]" />
			</p>';
		}
		return $output;
	}
	
	function hook_writestorypost(&$story) {
		//get_r('stype');
		foreach($_POST['opts'] as $opt) {
			if (strlen($opt)) {
				$options[] = array('flag'=>$opt,'num'=>0);
			}
		}
		if (count($options) < 2) {
			form_stop('You need to set at least 2 options!');
		}
		$story['text1'] = serialize($options);
		$story['var1'] = $_POST['stype'];
	}
	
	function hook_viewstory($row) {
		global $uhome;
		$opts = unserialize($row['text1']);
		$votes = explode(',',$row['text2']);
		$votes_total = count($votes);
		$output = '<form name="opt" action="'.url($this->name.'/vote').'" method="post">';
		$i = 1;
		foreach ($opts as $opt) {
			$votes_num += $opt['num'];
		}
		if (!$votes_num) {
			$votes_num = 1;
		}
		foreach($opts as $key => $opt) {
			$num = ceil($opt['num']/$votes_num*10);
			$pbar = '<img src="'.$uhome.'/modules/polls/poll_l.gif" />';
			for ($i=0; $i<=$num; $i++) {
				$pbar .= '<img src="'.$uhome.'/modules/polls/poll_m.gif" />';
			}
			$pbar .= '<img src="'.$uhome.'/modules/polls/poll_r.gif" /> ';
			if (!$row['var1']) {
				$output .= '<input type="radio" name="opts[]" value="'.$key.'" id="opt'.$i.'" /> '.$pbar.htmlspecialchars($opt['flag']).'<span class="sub">('.t('{1} votes',$opt['num']).')</span><br />';
			}
			else {
				$output .= '<div style="height:30px;"><input type="checkbox" name="opts[]" value="'.$key.'" id="opt'.$i.'" /> '.$pbar.htmlspecialchars($opt['flag']).'<span class="sub">('.t('{1} votes',$opt['num']).')</span></div>';
			}
			$i++;
		}
		$output .= '<input type="submit"  value="'.t('Vote').'" />
		<input type="hidden" name="sid" value="'.$row['id'].'" />
		</form>';
		return $output;
	}
	
	function vote() {
		global $client;
		do_auth(2);
		//get_r('sid');
		if (!$story = valid_story($_POST['sid'])) {
			sys_back('wrong sid');
		}
		$ori_opts = unserialize($story['text1']);
		$uids = explode(',',$story['text2']);
		if (in_array($client['id'],$uids)) {
			sys_back(t('You have voted before'));
		}
		if (!count($_POST['opts'])) {
			sys_back(t('No one selected'));
		}
		foreach ($ori_opts as $key=>$ori_opt) {
			if (in_array($key, $_POST['opts'])) {
				$ori_opts[$key]['num'] = $ori_opts[$key]['num'] + 1;
			}
		}
		$story['text1'] = serialize($ori_opts);
		$story['text2'] = $story['text2'].','.$client['id'];
		sql_update($story,tb().'stories');
		redirect($this->name.'/viewstory/'.$story['id'],1);
		
	}
	
	function story_form_content($row = array()) {
		return '<p>'.label(t('Description')).'<textarea name="form_content" class="form-control" >'.htmlspecialchars($row['content']).'</textarea></p>';
	}
	
	function theme_story_footer($row) {
		$votes = explode(',',$row['text2']);
		$output .= '<div class="tab_thing">'.t('{1} votes',(count($votes)-1)).'</div>';
		//$output .= '<div class="tab_thing">'.$this->list_views($row).'</div>';
		//$output .= '<div class="tab_thing">'.$this->list_comments($row).'</div>';
		return $output;
	}


	function ajax_form($page_type='') {
		global $client;
		if (!$client) die('login');
		echo '
								<strong>'.t('Type').'</strong>:
								<input type="radio" name="stype" value="0" checked /> '.t('Single selection').
								'<input type="radio" name="stype" value="1" /> '.t('Multiple selection').'<br />
		<strong>'.t('Question').'</strong>: <input type="text" size="55" name="poll_title" /><br />
								<strong>'.t('Options').'</strong>:
								<table border="0">';
		for($i=1;$i<=10;$i++) {
			echo '
			<tr><td>'.t('Option').$i.':</td><td>
			<input type="text" name="opts[]" size="45" /></td></tr>
			';
		}
		echo '</table>';

		if ($page_type == 'u') {
			echo topics_autocomplete_js().t('Tags').': <input type="text" size="25" class="topicbox" name="tags" /> <span class="sub">('.t('Separated with commas').')</span>';
		}
		exit;
	}

	function ajax_post() {
		global $client,$page_type;
		if (!$client) die('login');
		if (!$_POST['poll_title']) polls::ajax_error(t('Please input a Title'));
		$vote_options['rating'] = t('Rating');
		foreach ($vote_options as $key=>$vla) {
			$ratings[$key] = array('score'=>0,'users'=>0);
		}
		$page = story::check_page_access($_POST['page_id']);
		

		$story = array(
			'cid' => 0,
			'page_id' => $_POST['page_id'],
			'page_type'=>$page['type'],
			'title' => $_POST['poll_title'],
			'content' =>  nl2br(preg_replace('/<a /i','<a rel="nofollow external" ',$_POST['poll_content'])),
			'uid' => $client['id'],
			'created' => time(),
			'tags'=>$_POST['tags'],
			'app' => 'polls',
			'var5' => $_POST['privacy'],
			'rating' => serialize($ratings)
			);
		if (check_auto_approve()) {
			$story['featured'] = 1;
		}
		foreach($_POST['opts'] as $opt) {
			if (strlen($opt)) {
				$options[] = array('flag'=>$opt,'num'=>0);
			}
		}
		if (count($options) < 2) {
			polls::ajax_error(t('You need to set at least 2 options!'));
		}
		$story['text1'] = serialize($options);
		$story['var1'] = $_POST['stype'];
		if (sql_insert($story, tb().'stories')) {
			$sid = $story['id'] = insert_id();
			if (strlen($_POST['tags']) && check_auto_approve()) {
				parse_save_topics($_POST['tags'],$sid,'polls');
			}
			// write act
			$attachment = array(
				'cwall_id' => 'polls'.$sid,
				'uri' => 'polls/viewstory/'.$sid,
				'name' => $_POST['poll_title']
				);
			$app = array('name'=>'polls','id'=>$sid);
			$stream_id = stream_publish(t('added a poll'),$attachment,$app);
			$set_story['id'] = $sid;
			$set_story['stream_id'] = $stream_id;
			sql_update($set_story,tb()."stories");
			echo '<span style="background:yellow;color:black">'.t('Poll Added!').'</span> <a href="'.url('polls/viewstory/'.$sid).'"><strong>'.t('View').'</strong></a>';
		}
		else {
			polls::ajax_error('failed to add poll');
		}
		echo polls::ajax_form();
		exit;
	}
	function ajax_error($msg) {
		echo '<div style="color:red">'.$msg.'</div>';
		echo polls::ajax_form();
		exit;
	}
	
	
}
