<?php
/* ############################################################ *\
 ----------------------------------------------------------------
Jcow Software (http://www.jcow.net)
IS NOT FREE SOFTWARE
http://www.jcow.net/commercial_license
Copyright (C) 2009 - 2010 jcow.net.  All Rights Reserved.
 ----------------------------------------------------------------
\* ############################################################ */


class forums{
	function forums() {
		global $menuon,$parr;
		$menuon = 'forums';
		nav(url('forums',t('Forums')));
		set_title(t('Forums'));
		if ($parr[1] != 'recentthreads') {
			clear_as();
		}
	}

	function index() {
		global $settings,$config;
		$config['hide_ad'] = 1;
		// forum lists
		$categories = array();
		$q = "SELECT id,name from ".tb()."forums WHERE forum_type='category'  ORDER BY weight";
		$res = sql_query($q);
		$threads = $posts = 0;
		c('<table width="100%" class="stories">');
		c('<tr class="table_line2">
				<td width="51"></td>
				<td>'.t('Forum').'</td>
				<td width="60">'.t('Threads').'</td>
				<td width="60">'.t('Posts').'</td>
				<td width="250">'.t('Last post').'</td>
				</tr>');
		while ($category = sql_fetch_array($res)) {
			c('<tr class="table_line1"><td colspan="5">'.$category['name'].'</td></tr>');
			$q = "SELECT * FROM ".tb()."forums WHERE parent_id={$category['id']} ORDER BY weight";
			$res2 = sql_query($q, $conn);
			WHILE ($forum = sql_fetch_array($res2)) {
				$fsettings = unserialize($forum['settings']);
				if (!$fsettings['hide']) {
					// online
					$timeline = time()-$settings['online']*60;
					$lastpost = ' - ';
					if (strlen($forum['image']) > 10)
						$forum_image = '<img src="'.$forum['image'].'" align="left" />';
					else
						$forum_image = '';
					if ($forum['lastposttopicid']) {
						$lastpost = url('forums/viewthread/'.$forum['lastposttopicid'],h($forum['lastposttopic'])).'<br /><span class="sub">'.get_date($forum['lastpostcreated']).' by '.url('u/'.$forum['lastpostname'],$forum['lastpostname']).'</span>';
					}
					c('<tr class="row1">
						<td align="center"><img src="'.uhome().'/modules/forums/forum_icon.png" /></td>
						<td>'.$forum_image.'<strong>'.url('forums/listthreads/'.$forum['id'],h($forum['name'])).'</strong> <br /><span class="sub">'.$forum['description'].'</span></td>');
					if (!in_array(2,explode('|',$forum['read_roles'])) && !allow_access(explode('|',$forum['read_roles'])) && !forum_mod('',explode(',',$forum['moderators'])) ) {
						if ($forum['read_roles']) {
							$roles = array();
							$res4 = sql_query("select name from ".tb()."roles where id in(".str_replace('|',',',$forum['read_roles']).") order by id");
							while ($role = sql_fetch_array($res4)) {
								$roles[] = h($role['name']);
							}
							$forum['need_roles'] = '<br /><span class="sub">'.t('Allowed Roles').': '.implode(', ',$roles).'</span>';
						}
						c('<td colspan="3"><i>'.t('You have no permission to view this forum').'</i>'.$forum['need_roles'].'</td>');
					}
					else {
						c('<td>'.$forum['threads'].'</td>
						<td>'.$forum['posts'].'</td>
						<td>'.$lastpost.'</td>
						</tr>');
					}
				}
			}
		}
		if (allow_access(3)) {
			c('<tr class="row2"><td align="right"><i class="fa fa-trash"></i></td>
			<td  colspan="4">'.url('forums/listthreads/0',t('Recycle Bin')).'</td></tr>');
		}
		c('</table>');
	}

	function listthreads($fid) {
		global $offset, $num_per_page, $page, $forum_id, $settings, $client, $ss;
		$forum = valid_forum($fid);
		if (!forum_mod('',explode(',',$forum['moderators'])) && !$ss['is_bot']) {
			do_auth($forum['read_roles']);
		}
		$forum_id = $fid;
		nav(url('forums/listthreads/'.$forum['id'],h($forum['name'])));
		if ($fid > 0)
			button('forums/newthread/'.$fid, t('New Thread'));
		set_title(h($forum['name']));
		c('<table class="stories">
			<tr class="table_line1">
			<td colspan="6">'.h($forum['name']).'</td>
			</tr>
			<tr class="table_line2">
			<td ></td>
			<td>'.t('Title').'</td> 
			<td width="60">'.t('Views').'</td>
			<td width="60">'.t('Replies').'</td>
			');
		if (!$_SESSION['mobile_style']) {
			c('<td width="160">'.t('Last post').'</td>');
		}
		c('</tr>');
	

		
			
		$res = sql_query("SELECT t.*,u.disabled FROM ".tb()."forum_threads as t left join ".tb()."accounts as u on u.id=t.userid where t.fid='$fid'  ORDER by thread_type desc,lastpostcreated DESC LIMIT $offset,$num_per_page ");
		while ($row = sql_fetch_array($res)) {
			if ($row['disabled'] != 3) {
				$this->list_threads($row);
			}
		}
		c('</table>');

		// pager
		$pb       = new PageBar($forum['threads'], $num_per_page, $page);
		$pb->paras = url('/forums/listthreads/'.$fid);
		$pagebar  = $pb->whole_num_bar();
		c($pagebar);
		
		c('<br /><table class="stories"><tr class="table_line2"><td>'.t('Forum information').'</td></tr>
		<tr class="row1"><td>'.t('Moderators').': ');
		if (strlen($forum['moderators'])) {
			$moderators = explode(',',$forum['moderators']);
			foreach ($moderators as $moderator) {
				$mods[] = url('u/'.trim($moderator),$moderator);
			}
			c(implode(', ',$mods));
		}
		else {
			c('<i>None</i>');
		}
		c('</td></tr>
		</table>');
	}

	function recentthreads($pid) {
		if (!is_numeric($pid)) die();
		$res = sql_query("select * from ".tb()."pages where id='$pid'");
		$jcow_page = sql_fetch_array($res);
		if (!$jcow_page['id']) die('wrong page id');
		if ($jcow_page['uid'] == $client['id']) {
			button($this->name.'/writestory/'.$jcow_page['id'],$this->write_story);
		}
		if ($jcow_page['type'] != 'u') {
			die();
		}
		include_once('modules/u/u.php');
		if (!$user = u::settabmenu($jcow_page['uri'],1,'u')) die('wrong uname');
		$title = t("{1}'s {2}",$user['username'],$this->label_entry);
		$nav[] = url($this->name.'/liststories/page_'.$user['username'],$user['username']);
	
		c('<table class="stories">
			<tr class="table_line2">
			<td ></td>
			<td>'.t('Title').'</td> 
			<td width="60">'.t('Views').'</td>
			<td width="60">'.t('Replies').'</td>');
		if (!$_SESSION['mobile_style']) {
			c('<td width="160">'.t('Last post').'</td>');
		}
		c('	</tr>');
			
		$res = sql_query("SELECT * FROM ".tb()."forum_threads where userid='{$jcow_page['uid']}'  ORDER by thread_type desc,lastpostcreated DESC LIMIT 10");
		while ($row = sql_fetch_array($res)) {
			$this->list_threads($row);
		}
		c('</table>');
		section_close();
	}
	
	function list_threads($row) {
		global $num_per_page;
		if (!$row['lastreply']) {
				$row['lastreply'] = $row['created'];
				$row['lastreplyuid'] = $row['uid'];
				$row['lastreplyuname'] = $row['username'];
			}
			if ($row['got_poll']) $row['type'] = t('Poll').': ';
			$icon = 'topic_standard.gif';
			if ($row['posts'] >= 12) {
				$icon = 'topic_hot.gif';
			}
			if ($row['thread_lock']) {
				$icon = 'topic_lock.gif';
			}
			if ($row['thread_type'] == 1) {
				$icon = 'topic_sticky.gif';
			}
			if ($row['thread_type'] == 2) {
				$icon = 'topic_global.gif';
			}
			if ($row['posts'] > $num_per_page) {
				$pager = array();
				$thread_url = url('forums/viewthread/'.$row['id']);
				if (preg_match("/\?/",$thread_url)) {
					$thread_url = $thread_url.'&';
				}
				else {
					$thread_url = $thread_url.'?';
				}
				$row['pager'] = ' <span class="sub"><img src="'.uhome().'/files/common_css/pager_icon.png" /> ';
				$pager[] = url($thread_url,'1');
				$pager[] = url($thread_url.'page=2','2');
				if ($row['posts'] > ($num_per_page*2)) {
					$num = ceil($row['posts']/$num_per_page);
					$pager[] = url($thread_url.'page='.$num,$num);
				}
				$row['pager'] .= implode(', ',$pager);
				$row['pager'] .= '</span>';
			}
			$res = sql_query("select id,username,fullname,avatar from jcow_accounts where username='{$row['lastpostusername']}'");
			$user = sql_fetch_array($res);
			if ($user['id']) {
				$lastpost = '<span class="sub">'.get_date($row['lastpostcreated']).'</span><br />
				<span class="sub">by '.url('u/'.$row['lastpostusername'],avatar($user,25,array('nolink'=>1)).' '.h($user['fullname'])).'</span>';
			}
			$attach = $row['got_attach'] ? ' <img src="'.uhome().'/files/icons/forums/topic_attach.gif" alt="got attachments" />' : '';
			$uicon = $row['icon'] ? '<img src="'.uhome().'/files/icons/forums/icon'.$row['icon'].'.png"  />' : ' ';
			c('<tr class="row1">
			<td width="40" align="center"><img src="'.uhome().'/files/icons/forums/'.$icon.'" /></td>
			<td><span class="forum_title">'.$row['type'].url('forums/viewthread/'.$row['id'],h($row['topic'])).$attach.$row['pager'].'</span>'.$row['pending_review'].'<br /><span class="sub">by '.url('u/'.$row['username'],$row['username']).', '.get_date($row['created']).'</span></td>
			<td align="center">'.$row['views'].'</td>
			<td align="center">'.($row['posts']-1).'</td>');
			if (!$_SESSION['mobile_style']) {
				c('<td>'.$lastpost.'</td>');
			}
			c('</tr>');
		}

	function viewthread($tid) {
		global $page, $offset, $num_per_page, $client, $settings, $ss, $config;
		enable_jcow_inline_ad();
		$thread = valid_thread($tid);
		if ($thread['fid'] == 0) {
			if (!forum_mod()) {
				die('Sorry, This thread is in Recyle Bin');
			}
		}
		$forum = valid_forum($thread['fid']);
		if (!forum_mod('',explode(',',$forum['moderators']))  && !$ss['is_bot']) {
			do_auth($forum['read_roles']);
		}
		nav(url('forums/listthreads/'.$forum['id'],h($forum['name'])));
		nav(url('forums/viewthread/'.$thread['id'],h($thread['topic'])));
		set_title(h($thread['topic']));
		enreport();
		if ($thread['got_poll']) {
			$res = sql_query("select * from ".tb()."forum_polls where tid='{$thread['id']}'  limit 1");
			$poll = sql_fetch_array($res);
			c('<table class="stories"><tr class="table_line1"><td>'.h($poll['question']).'</td></tr></table>');
			$opts = unserialize($poll['options']);
			c('<table class="stories">');
			c('<form method="post" action="'.url('forums/vote').'" />');
			c('<tr class="table_line2"><td>'.t('Options').' ('.t('Maximum selection').': <strong>'.$poll['options_per_user'].'</strong>)</td><td width="50%">'.t('Votes').'</td></tr>');
			$opt_type = 'radio';
			if ($poll['options_per_user'] > 1) $opt_type = 'checkbox';
			if (is_array($opts)) {
				foreach ($opts as $key=>$opt) {
					$length = ceil($opt['votes']*100/($poll['total']+1));
					$alpha = 0.4;
					$alpha2 = 40;
					if ($length >= 20) {
						$alpha = 0.6;
						$alpha2 = 60;
					}
					if ($length >= 30) {
						$alpha = 0.8;
						$alpha2 = 80;
					}
					if ($length > 40) {
						$alpha = 0.9;
						$alpha2 = 90;
					}
					if ($length > 50) {
						$alpha = 1;
						$alpha2 = 100;
					}
					
					c('<tr class="row1"><td><input type="'.$opt_type.'" value="'.$key.'" name="keys[]" />
					 '.h($opt['option']).'</td><td><div class="votes" style="width:'.$length.'%;filter:alpha(opacity='.$alpha2.');opacity: '.$alpha.';-moz-opacity:'.$alpha.';">'.$opt['votes'].'</div></td></tr>');
				}
			}
			c('<tr class="row2"><td colspan="2">
			<input type="hidden" name="poll_id" value="'.$poll['id'].'" />');
			if ($poll['timeout'] > time()) {
				if ($client['id'] && preg_match("/,".$client['id']."(,|$)/",$poll['voters']))
					c('<input type="submit" value="'.t('Voted').'" disabled />');
				else
					c('<input type="submit" value="'.t('Vote').'" />');
			}
			else {
				c('Closed in '.get_date($poll['timeout'],'date'));
			}
			c(' ('.t('{1} people voted',$poll['total']).')</td></tr>
			</form></table><br />');
		}
		c('<table class="stories"><tr class="table_line1"><td>'.h($thread['topic']).' </td></tr></table>');
		$res = sql_query("SELECT p.*,u.disabled,u.username,u.avatar,u.fullname,u.forum_posts,u.created as ucreated,u.lastlogin FROM ".tb()."forum_posts as p left join ".tb()."accounts as u on u.id=p.uid where p.tid='$tid' ORDER by p.id LIMIT $offset,$num_per_page ");
		
		while ($post = sql_fetch_array($res)) {
			if ($post['is_first']) {
				button('forums/newthread/'.$forum['id'], t('New Thread'));
				button('forums/newreply/'.$post['id'], t('New Reply'));
			}
			if (!$post['lastreply']) {
				$post['lastreply'] = $post['created'];
				$post['lastreplyuid'] = $post['uid'];
				$post['lastreplyuname'] = $post['username'];
			}
			$icon = 'topic_1.gif';
			if ($post['lastlogin'] > (time()-300))
				$post['user_online'] = '<img src="'.uhome().'/files/icons/online.gif" />';
			else
				$post['user_online'] = '<img src="'.uhome().'/files/icons/offline.gif" />';
			if ($post['comments'] >= 5 or $post['views'] >= 100) {
				$icon = 'topic_2.gif';
			}
			c('<table class="stories">');
			c('<tr class="row1">
			<td>
				<table border="0" width="100%">
				<tr><td width="55" style="padding:0">'.avatar($post).'</td>
				<td >'.h($post['fullname']).' <span class="sub">(@'.$post['username'].')</span> '.$post['user_online'].'
				<div style="font-size:0.9em">'.t('Join date').': '.get_date($post['ucreated'],'date')
				.'<br />'.t('Community posts').': '.$post['forum_posts'].'</div>
				</td>
				<td style="font-size:0.9em" align="right">'.url('u/'.h($post['fullname']),t('View Profile')).'<br />'.url('message/compose/u'.$post['uid'],t('Send Message')).'<br />
				'.add_friend_btn($post['uid']).'
				</td>
				</tr></table>
			</td></tr>
			<tr class="row2">
			<td>
			<!-- content -->');
			if ($post['disabled'] == 3) {
				c('<i><span class="sub">Marked as spam</span></i>');
			}
			else {
				//c(nl2br(decode_bb(h($post['message']))));
				c(Parsedown::instance()->setBreaksEnabled(true)->setMarkupEscaped(true)->text($post['message']));
				if ($post['got_attach']) {
					c('<fieldset><legend>'.t('Attachments').'</legend>');
					$res2 = sql_query("select * from ".tb()."forum_attachments where pid='{$post['id']}'");
					while ($attach = sql_fetch_array($res2)) {
						c('<p>');
						if (preg_match("/(gif|jpg|png)$/i",$attach['orginal_name'])) {
							c('<span class="sub">'.h($attach['des']).'</span>');
							c('<br /><img src="'.uhome().'/'.$attach['uri'].'" />');
						}
						else {
							c('<strong>'.h($attach['orginal_name']).'</strong> ('.get_filesize($attach['size']).', '.$attach['downloads'].' downloads)<br /><span class="sub">'.h($attach['des']).'</span><a href="'.url('forums/download/'.$attach['id']).'"> '.t('Download').'</a>');
						}
						c('</p>');
					}
					c('</fieldset>');
				}
			}

			
			if ($post['disabled'] != 3) {
				c('<table border="0" width="100%">
				<tr><td><span class="sub"> '.get_date($post['created']).'</span></td><td>'.$this->post_operations($post).'</td></tr></table>');
			}
			
			if ($post['stream_id']) {
				c('
				<div style="width:150px;float:right;clear:both;">');
				c(likes_get($post['stream_id']));
				c('</div>');
			}
			c('</td>
			</tr></table>
			<div style="height:12px"></div>');
		}

		// pager
		$pb       = new PageBar($thread['posts'], $num_per_page, $page);
		$pb->paras = url('/forums/viewthread/'.$tid);
		$pagebar  = $pb->whole_num_bar();
		c($pagebar);
		$set_thread['id'] = $thread['id'];
		$set_thread['views'] = $thread['views'] + 1;
		sql_update($set_thread,tb().'forum_threads');
		if ($thread['old_fid']) {
			$res = sql_query("select name from ".tb()."forums where id='{$thread['old_fid']}' ");
			$row = sql_fetch_array($res);
			c('<div>'.t('This thread was moved from {1}',url('forums/listthreads/'.$thread['old_fid'],h($row['name']))).'</div>');
		}
		c('<table border="0" width="100%"><tr><td> ');
		if (forum_mod($thread['fid'])) {
			c('<form method="post" action="'.url('forums/mod_thread').'" />
			'.t('Manage').':<select name="mod_type">
			<option value="0">Select..</option>');
			if ($thread['fid'] == 0) {
				if (allow_access(3)) {
					c('<option value="torecover">'.t('Recover thread').'</option>
					<option value="todelete">'.t('Delete thread').'</option>');
				}
			}
			else {
				if ($thread['thread_lock']) {
					c('<option value="tounlock">'.t('Unlock thread').'</option>');
				}
				else {
					c('<option value="tolock">'.t('Lock thread').'</option>');
				}
				c('<option value="tomove">'.t('Move thread to other Forums').'</option>
				<option value="torecyle">'.t('Move thread to Recycle Bin').'</option>');
				if (allow_access(3)) {
					c('<option value="todelete">'.t('Delete thread').'</option>');
				}
				if ($thread['thread_type'] > 0) {
					c('<option value="tostandard">'.t('Change to Standard').'</option>');
				}
				else {
					c('<option value="tosticky">'.t('Change to Sticky').'</option>
				<option value="toglobal">'.t('Change to Global').'</option>');
				}
			}
			c('</select>
			<input type="hidden" name="tid" value="'.$thread['id'].'" />
			<input type="submit" value="Go" />
			</form>');
		}
		if ($client['id']) {
			$subscribe = sql_query("select * from ".tb()."forum_subscribes where tid='{$thread['id']}' and uid='{$client['id']}'");
			if (sql_counts($subscribe)) {
				$subscribe_url = url('forums/unsubscribe/'.$thread['id'],t('Un-Subscribe'));
			}
			else {
				$subscribe_url = '<img src="'.uhome().'/files/icons/add.png" />'.url('forums/subscribe/'.$thread['id'],t('Subscribe') );
			}
		}
		else {
			$subscribe_url = '';
		}
		//c('</td><td align="right">'.$subscribe_url.'</td></tr></table>');
		section_close();
		if (!$thread['thread_lock'] && $client['id']) {
			c('<form method="post" action="'.url('forums/newreplypost').'" class="ajaxform">');
			c(post_form(6,array('message'=>'@'.$thread['username'].' ')).'
			<p>
							<input class="button" type="submit" value="'.t('Submit').'" />
							<input type="hidden" name="pid" value="'.$thread['pid'].'" />
							</p>
			</form>');
			section_close(t('Quick reply'));
		}
	}

	function subscribe($tid) {
		global $client;
		if (!$client['id']) die('please login');
		$thread = valid_thread($tid);
		if ($thread['fid'] == 0) {
			if (!forum_mod()) {
				die('Sorry, This thread is in Recyle Bin');
			}
		}
		$forum = valid_forum($thread['fid']);
		if (!forum_mod('',explode(',',$forum['moderators']))  && !$ss['is_bot']) {
			do_auth($forum['read_roles']);
		}
		$subscribe = sql_query("select * from ".tb()."forum_subscribes where tid='{$thread['id']}' and uid='{$client['id']}'");
		if (!sql_counts($subscribe)) {
			sql_insert(array('uid'=>$client['id'],'tid'=>$thread['id']),tb()."forum_subscribes");
		}
		redirect(url('forums/viewthread/'.$tid),1);
	}

	function unsubscribe($tid) {
		global $client;
		if (!$client['id']) die('please login');
		$thread = valid_thread($tid);
		sql_query("delete from ".tb()."forum_subscribes where tid='{$thread['id']}' and uid='{$client['id']}'");
		redirect(url('forums/viewthread/'.$tid),1);
	}

	
	function mod_thread() {
		global $client;
		need_login();
		$thread = valid_thread($_POST['tid']);
		if (!forum_mod($thread['fid'])) die('access denied');
		$set_thread['id'] = $thread['id'];
		switch($_POST['mod_type']) {
			case 'tosticky':
				$set_thread['thread_type'] = 1;
				sql_update($set_thread,tb().'forum_threads');
				break;
			case 'toglobal':
				$set_thread['thread_type'] = 2;
				sql_update($set_thread,tb().'forum_threads');
				break;
			case 'tostandard':
				$set_thread['thread_type'] = 0;
				sql_update($set_thread,tb().'forum_threads');
				break;
			case 'tolock':
				$set_thread['thread_lock'] = 1;
				sql_update($set_thread,tb().'forum_threads');
				redirect(url('forums/viewthread/'.$thread['id']),1);
				break;
			case 'tomove':
				$res = sql_query("select name from ".tb()."forums where id='{$thread['fid']}' ");
				$row = sql_fetch_array($res);
				c('Move This thread: '.url('forums/viewthread/'.$thread['id'],h($thread['topic'])));
				c('<br />From '.url('forums/listthreads/'.$thread['fid'],$row['name']));
				c('<br />to:
				<form action="'.url('forums/movethread').'" method="post">
				<select name="new_fid">');
				$res = sql_query("select f.*,g.name as gname from ".tb()."forums as f left join ".tb()."forums as g on g.id=f.parent_id where f.forum_type='forum' order by f.parent_id");
				while ($row = sql_fetch_array($res)) {
					c('<option value="'.$row['id'].'">'.h($row['gname']).' - '.h($row['name']).'</option>');
				}
				c('</select>
				<input type="submit" value="Go" />
				<input type="hidden" name="tid" value="'.$thread['id'].'" />
				</form>');
				stop_here();
				break;
			case 'torecover':
				$set_thread['fid'] = $thread['old_fid'];
				$set_thread['old_fid'] = 0;
				sql_update($set_thread,tb().'forum_threads');
				// update num
				sql_query("update ".tb()."forums set threads=threads+1,posts=posts+{$thread['posts']} where id='{$thread['old_fid']}' ");
				redirect(url('forums/viewthread/'.$thread['id']),1);
				break;
			case 'tounlock':
				$set_thread['thread_lock'] = 0;
				sql_update($set_thread,tb().'forum_threads');
				redirect(url('forums/viewthread/'.$thread['id']),1);
				break;
			case 'torecyle':
				c('Are you sure to Move the thread to Recyle Bin: '.url('forums/viewthread/'.$thread['id'],h($thread['topic'])).'?');
				c('<p>'.url('forums/recylethread/'.$thread['id'],t('Yes')).', <a href="#" onclick="javascript:history.go(-1)">'.t('No').'</a></p>');
				stop_here();
				break;				
			case 'todelete':
				c('Are you sure to Delete this thread: '.url('forums/viewthread/'.$thread['id'],h($thread['topic'])).'?');
				c('<p>'.url('forums/deletethread/'.$thread['id'],t('Yes')).', <a href="#" onclick="javascript:history.go(-1)">'.t('No').'</a></p>');
				stop_here();
				break;
			}
		redirect(url('forums/listthreads/'.$thread['fid']),1);
	}
	
	function movethread() {
		global $client;
		need_login();
		$thread = valid_thread($_POST['tid']);
		$forum = valid_forum($thread['fid']);
		$new_forum = valid_forum($_POST['new_fid']);
		if (!forum_mod($thread['fid'])) die('access denied');
		$set_thread['id'] = $thread['id'];
		$set_thread['old_fid'] = $thread['fid'];
		$set_thread['fid'] = $new_forum['id'];
		sql_update($set_thread,tb().'forum_threads');
		// update num
		sql_query("update ".tb()."forums set threads=threads+1,posts=posts+{$thread['posts']} where id='{$_POST['new_fid']}' ");
		sql_query("update ".tb()."forums set threads=threads-1,posts=posts-{$thread['posts']} where id='{$thread['fid']}' ");
		redirect(url('forums/viewthread/'.$thread['id']),1);
	}
	
	function recylethread($tid) {
		global $client;
		need_login();
		$thread = valid_thread($tid);
		if (!forum_mod($thread['fid'])) die('access denied');
		$set_thread['id'] = $thread['id'];
		$set_thread['old_fid'] = $thread['fid'];
		$set_thread['fid'] = 0;
		sql_update($set_thread, tb()."forum_threads");
		// update num
		sql_query("update ".tb()."forums set threads=threads-1,posts=posts-{$thread['posts']} where id='{$thread['fid']}' ");
		redirect(url('forums/listthreads/'.$thread['fid']),1);
	}
	
	function deletethread($tid) {
		global $client;
		need_login();
		$thread = valid_thread($tid);
		if (!forum_mod($thread['fid'])) die('access denied');
		// delete thread
		sql_query("delete from ".tb()."forum_threads where id='$tid' ");
		// delete post
		sql_query("delete from ".tb()."forum_posts where tid='$tid' ");
		// delete attach
		$res = sql_query("select * from ".tb()."forum_attachments where tid='$tid' ");
		while ($attach = sql_fetch_array($res)) {
			sql_query("delete from ".tb()."forum_attachments where id='{$attach['id']}' ");
			unlink($attach['uri']);
		}
		// update num
		sql_query("update ".tb()."forums set threads=threads-1,posts=posts-{$thread['posts']} where id='{$thread['fid']}' ");
		redirect(url('forums/listthreads/'.$thread['fid']),1);
	}
	
	
	function download($aid) {
		global $client, $from_url;
		$res = sql_query("select * from ".tb()."forum_attachments where id='$aid' ");
		$attach = sql_fetch_array($res);
		if (!$attach['id']) die('wrong aid');
		$res = sql_query("select * from ".tb()."forum_posts where id='{$attach['pid']}' ");
		$post = sql_fetch_array($res);
		if (!$post['id']) die('wrong pid from aid');
		$thread = valid_thread($post['tid']);
		$forum = valid_forum($thread['fid']);
		if (!preg_match('/'.str_replace('/','\/',uhome()).'/',$from_url)) die('Sorry, you should download files from forum thread');
		if (!forum_mod('',explode(',',$forum['moderators'])) ) {
			do_auth($forum['read_roles']);
		}
		if ($attach['uri']) {
			$ext = substr($attach['orginal_name'],-3,3);
			if (preg_match("/\./",$ext)) $ext = substr($ext,-2,2);
			header("Content-disposition: filename=".$attach['orginal_name']);
			header("Content-type: ".$ext);
			readfile($attach['uri']);
		}
		else die('no file uri');
		$q = "UPDATE ".tb()."forum_attachments SET downloads=downloads+1 WHERE id='$aid' ";
		sql_query($q, $conn);

	}

	function vote() {
		global $client;
		if (!$client['id']) {
			redirect('member/login/1');
		}
		if (!count($_POST['keys']))
			sys_back('No option selected');
		$res = sql_query("select * from ".tb()."forum_polls where id='{$_POST['poll_id']}' ");
		$poll = sql_fetch_array($res);
		if (!$poll['id']) die('wrong pid');
		if (preg_match('/,'.$client['id']."(,|$)/",$poll['voters']))
			sys_back('You have voted before');
		$thread = valid_thread($poll['tid']);
		$opts = unserialize($poll['options']);
		for ($i=0; $i< $poll['options_per_user']; $i++) {
			if (is_numeric($_POST['keys'][$i])) {
				$key = $_POST['keys'][$i];
				if (is_array($opts[$key]))
					$opts[$key]['votes']++;
			}
		}
		$set_poll['id'] = $poll['id'];
		$set_poll['options'] = serialize($opts);
		$set_poll['voters'] = $poll['voters'].','.$client['id'];
		$set_poll['total'] = $poll['total'] + 1;
		sql_update($set_poll,tb().'forum_polls');
		redirect('forums/viewthread/'.$thread['id'],1);
	}

	function newthread($fid) {
		limit_posting(1,0,'community_post');
		global $client;
		$forum = valid_forum($fid);
		if (!forum_mod('',explode(',',$forum['moderators'])) ) {
			do_auth($forum['thread_roles']);
		}
		if (!$client['id']) {
			redirect('member/login/1');
		}
		nav(url('forums/listthreads/'.$forum['id'],h($forum['name'])));
		c('
		<form method="post" action="'.ubase().'forums/newthreadpost">');
		if (strlen(get_text('forum_post_rule'))) {
			c('
	  <div style="background:#eee;color:black;border:#ccc 1px solid;padding:3px;margin:5px;">
			<div style="padding:5px;font-weight:bold">'.t('Posting Rules').'</div><br />
			'.get_text('forum_post_rule').'<br /><br /></div>');
		}
		c('<p>
						'.label(t('Title')).'
						<input type="text" name="title" style="width:600px;height:30px;font-size:20px" />
		</p>');
		c(post_form());
		c('<p>
						'.label(t('Post options')).'</label>
						<input type="checkbox" name="parseurl" value="1" checked /> '.t('Automatically parse URLs').' ');
		if (allow_access($forum['upload_roles'])) {
			if (!$safe_community_posts = get_gvar('safe_community_posts')) {
				$safe_community_posts = 5;
			}
			if ($client['forum_posts'] >= $safe_community_posts) {
				c('<br /><input type="checkbox" name="attachment" value="1" /> '.t('Upload attachments on the next step'));
			}
		}
		c('
						</p>
					<p>'.label(t('Poll')).'
		<label><input type="checkbox" name="createapoll" value="1" /> '.t('Create a poll').'</label>
		</p>
		<script type="text/javascript">
	    jQuery(document).ready(function($) {
	    	$("input[name=\'createapoll\']").click(
	    		function() {
	    		$("#poll_creation").toggle("slow");
	    		}
	    		);
	    })
	  </script>
	  <div id="poll_creation" style="display:none">
	  <fieldset>'.label(t('Poll')).'</legend>
	  <p>'.label(t('Poll question')).'<input type="text" size="40" name="poll_question" />
	  </p>
	  <p>'.label(t('Running days')).'</label><input type="text" size="2" name="poll_run_days" value="7" />
	  </p>
	  <p>'.label(t('Poll options')).'</label><textarea name="poll_options" rows="13"></textarea><br />
	  <span>'.t('Place each option on a new line. You may enter up to 13 options').'</span></p>
	  <p><label>'.t('Options per user').'</label><input type="text" size="2" name="options_per_user" value="1" />
	  <span>'.t('This is the number of options each user may select when voting').'</span></p>
	  </div>');
		c('
		<input type="hidden" name="fid" value="'.$fid.'" />
		<p>
						<input class="button" type="submit" value="'.t('Submit').'" />
						</p>
		</form>');
		section_close(t('New Thread'));
	}
	function newthreadpost() {
		global $client;
		if (!$client['id']) {
			redirect('member/login/1');
		}
		$forum = valid_forum($_POST['fid']);
		if (!forum_mod('',explode(',',$forum['moderators'])) ) {
			do_auth($forum['thread_roles']);
		}
		$thread['topic'] = $_POST['title'];
		$thread['fid'] = $_POST['fid'];
		$thread['username'] = $client['uname'];
		$thread['userid'] = $client['id'];
		$thread['icon'] = $_POST['icon'];
		$thread['posts'] = 1;
		$thread['lastpostusername'] = $client['uname'];
		$thread['created'] = time();
		$thread['lastpostcreated'] = time();
		$post['title'] = $_POST['title'];
		if ($_POST['parseurl']) $_POST['form_content'] = parseurl($_POST['form_content']);
		$post['message'] = $_POST['form_content'];
		check_thread($thread);
		check_post($post);
		// poll
		if ($_POST['createapoll']) {
			$thread['got_poll'] = 1;
			if (strlen($_POST['poll_question']) < 5)
				sys_back(t('Poll question is too short'));
			$poll_options = stripslashes($_POST['poll_options']);
			$poll_options = explode("\r\n",$poll_options);
			foreach ($poll_options as $val) {
				if (strlen(trim($val)) > 0)
					$poll_opts[] = array('option'=>$val,'votes'=>0);
			}
			if ($_POST['poll_run_days'] < 1)
				sys_back(t('Please input a valid poll running days'));
			$timeout = time() + $_POST['poll_run_days']*3600*24;
			if (count($poll_opts) < 2)
				sys_back(t('You need to set at least 2 options'));
			if ($_POST['options_per_user'] < 1 || $_POST['options_per_user'] > count($poll_opts))
				sys_back(t('Please input a valid "options per user"'));
			$poll['options'] = serialize($poll_opts);
			$poll['question'] = $_POST['poll_question'];
			$poll['created'] = time();
			$poll['options_per_user'] = $_POST['options_per_user'];
			$poll['timeout'] = $timeout;
		}
		limit_posting(0,0,'community_post');
		sql_insert($thread,tb().'forum_threads');
		$tid = insert_id();
		if ($_POST['subscribe']) {
			sql_insert(array('uid'=>$client['id'],'tid'=>$tid),tb()."forum_subscribes");
		}
		if ($_POST['createapoll']) {
			$poll['tid'] = $tid;
			sql_insert($poll,tb().'forum_polls');
		}
		$post['tid'] = $tid;
		$post['is_first'] = 1;
		$post['uid'] = $client['id'];
		$post['created'] = time();


		sql_insert($post,tb().'forum_posts');
		$pid = insert_id();

		if (in_array(1,$forum['read_roles']) || in_array(2,$forum['read_roles'])) {
			$attachment = array(
					'cwall_id' => 'none',
					'uri' => 'forums/viewthread/'.$tid,
					'name' => h($_POST['title'])
					);
			$app = array('name'=>'forums','id'=>$tid);
			$replyurl = url('forums/newreply/'.$pid,t('Reply'));
			$stream_id = stream_publish(
				addslashes(h(utf8_substr(stripslashes($_POST['form_content']),120)).' '.$replyurl),
				$attachment,$app);
		}
		sql_query("update ".tb()."forum_posts set stream_id='$stream_id' where id='$pid'");


		$set_thread['id'] = $tid;
		$set_thread['pid'] = $pid;
		sql_update($set_thread,tb().'forum_threads');

				$return = parse_mentions($_POST['form_content']);
				add_mentions($return['mentions'],$stream_id);
				sql_query("update ".tb()."accounts set forum_posts=forum_posts+1 where id='{$client['id']}'");
				$set_forum['id'] = $forum['id'];
				$set_forum['posts'] = $forum['posts'] + 1;
				$set_forum['threads'] = $forum['threads'] + 1;
				$set_forum['lastpostname'] = $client['uname'];
				$set_forum['lastpostcreated'] = time();
				$set_forum['lastposttopic'] = $_POST['title'];
				$set_forum['lastposttopicid'] = $tid;
				sql_update($set_forum,tb().'forums');
		
		if ($_POST['attachment'])
			redirect('forums/attachments/'.$pid,1);
		else
			redirect('forums/viewthread/'.$tid,1);
	}
	function newreply($pid, $quote = false) {
		limit_posting(1,0,'community_post');
		global $client;
		if (!$client['id']) {
			redirect('member/login/1');
		}
		$res = sql_query("select * from ".tb()."forum_posts where id='$pid' ");
		$post = sql_fetch_array($res);
		if (!$post['id']) die('wrong pid');
		$thread = valid_thread($post['tid']);
		if ($thread['thread_lock']) {
			sys_back(t('Sorry, this thread has been locked'));
		}
		$forum = valid_forum($thread['fid']);
		if (!forum_mod('',explode(',',$forum['moderators'])) ) {
			do_auth($forum['thread_roles']);
		}
		nav(url('forums/listthreads/'.$forum['id'],h($forum['name'])));
		nav(url('forums/viewthread/'.$thread['id'],h($thread['topic'])));
		c('
		<form method="post" action="'.url('forums/newreplypost').'" class="ajaxform">');
		$res = sql_query("select username from ".tb()."accounts where id='{$post['uid']}' ");
		$user = sql_fetch_array($res);	

		if ($quote) {
			/*
			$sfrom = array(
            "/\[quote](.*)\[\/quote]/isU",
			"/\[quote=([0-9a-z_@]+)](.*)\[\/quote]/isU"
			);
			$sto = array('','');
			*/
			$arr = explode("\r\n",$post['message']);
			foreach ($arr as $val) {
				$newmsg .= '>'.$val."\r\n";
			}
			$set_post = array('message' => $newmsg."\r\n".'@'.$user['username'].' ');
		}
		else {
			$set_post = array('message' => '@'.$user['username'].' ');
		}
		c(post_form(16, $set_post));
		c('
		<p>
						<label>'.t('Post options').'</label>
						<input type="checkbox" name="parseurl" value="1" checked />'.t('Automatically parse URLs').'<br />
						<input type="checkbox" name="attachment" value="1" />'.t('Upload attachments on the next step').'
						</p>
		<input type="hidden" name="pid" value="'.$pid.'" />
		<input type="submit" class="button" value="'.t('Submit').'" />
		</form>');
		section_close(t('New Reply'));
	}
	
	function newreplypost() {
		global $client,$num_per_page;
		if (!$client['id']) {
			redirect('member/login/1');
		}
		$res = sql_query("select * from ".tb()."forum_posts where id='{$_POST['pid']}' ");
		$post = sql_fetch_array($res);
		if (!$post['id']) die('wrong pid');
		$thread = valid_thread($post['tid']);
		if ($thread['thread_lock']) {
			die(t('Sorry, this thread has been locked'));
		}
		$forum = valid_forum($thread['fid']);
		if (!forum_mod('',explode(',',$forum['moderators'])) ) {
			do_auth($forum['thread_roles']);
		}
		$set_post['tid'] = $thread['id'];
		$set_post['title'] = $_POST['title'];
		if ($_POST['parseurl']) $_POST['form_content'] = parseurl($_POST['form_content']);
		$set_post['message'] = $_POST['form_content'];
		$set_post['uid'] = $client['id'];
		$set_post['created'] = time();
		check_post($set_post);
		limit_posting(0,0,'community_post');
		sql_insert($set_post,tb().'forum_posts');
		$pid = insert_id();

		$posturl = url('forums/viewthread/'.$thread['id']);
		$set_thread['id'] = $thread['id'];
		$set_thread['posts'] = $thread['posts']+1;

		if ($set_thread['posts'] > $num_per_page) {
			$num = ceil($set_thread['posts']/$num_per_page);
			if (preg_match("/\?/",$thread_url)) {
				$posturl = $posturl.'&page='.$num;
			}
			else {
				$posturl = $posturl.'?page='.$num;
			}
		}
		$posturl = $posturl.'#num'.$post['id'];
		
		if (in_array(1,$forum['read_roles']) || in_array(2,$forum['read_roles'])) {
			$posturl = '<a href="'.$posturl.'">'.t('View').'</a>';
			$attachment = array(
					'cwall_id' => 'none',
					'name'=> t('Reply to'),
					'des' => addslashes(h(utf8_substr($post['message'],60)))
					);
			$app = array('name'=>'forums','id'=>$thread['id']);
			$replyurl = url('forums/newreply/'.$pid,t('Reply'));
			$search_array = array(
            "/\[quote](.*)\[\/quote]/isU",
			"/\[quote=([0-9a-z_@]+)](.*)\[\/quote]/isU"
			);
			$replace_array = array('','');
			$stream_msg = preg_replace($search_array, $replace_array, $_POST['form_content']);
			$stream_id = stream_publish(
				addslashes(h(utf8_substr(stripslashes($stream_msg),120)).' '.$posturl.' | '.$replyurl),
				$attachment,$app);
			sql_query("update ".tb()."forum_posts set stream_id='$stream_id' where id='$pid'");
		}
		
		


		$set_thread['lastpostusername'] = $client['uname'];
		$set_thread['lastpostcreated'] = time();
		$set_forum['id'] = $forum['id'];
		$set_forum['posts'] = $forum['posts'] + 1;
		$set_forum['lastpostname'] = $client['uname'];
		$set_forum['lastpostcreated'] = time();
		$set_forum['lastposttopic'] = addslashes($thread['topic']);
		$set_forum['lastposttopicid'] = $thread['id'];
				
				$return = parse_mentions($_POST['form_content']);
				add_mentions($return['mentions'],$stream_id);
				sql_query("update ".tb()."accounts set forum_posts=forum_posts+1 where id='{$client['id']}'");
				sql_update($set_thread,tb().'forum_threads');
				sql_update($set_forum,tb().'forums');


		if ($_POST['attachment'])
			form_go(url('forums/attachments/'.$pid));
		else {
			$thread_url = url('forums/viewthread/'.$thread['id']);
			$thread['posts']++;
			if ($thread['posts'] > $num_per_page) {
				$num = ceil($thread['posts']/$num_per_page);
				if (preg_match("/\?/",$thread_url)) {
					$thread_url = $thread_url.'&page='.$num;
				}
				else {
					$thread_url = $thread_url.'?page='.$num;
				}
			}
			form_go($thread_url);
		}
	}


	function editpost($pid) {
		global $client;
		if (!$client['id']) {
			redirect('member/login/1');
		}
		$res = sql_query("select * from ".tb()."forum_posts where id='$pid' ");
		$post = sql_fetch_array($res);
		if (!$post['id']) die('wrong pid');
		if ($post['uid'] != $client['id']) die('access denied');
		if ((time()-$post['created']) > 7200 && !forum_mod($forum['id'])) {
			c(t('Sorry, you can not edit posts older than 2 hours'));
			stop_here();
		}
		$thread = valid_thread($post['tid']);
		$forum = valid_forum($thread['fid']);
		nav(url('forums/listthreads/'.$forum['id'],h($forum['name'])));
		nav(url('forums/viewthread/'.$thread['id'],h($thread['topic'])));
		c('<table class="stories">
		<tr class="table_line1"><td colspan="2">'.t('Edit post').'</td></tr></table>');
		c('<form action="'.url('forums/editpostpost').'" method="post">
		<p><label>'.t('Title').'</label><input type="text" style="width:600px;height:30px;font-size:20px" name="title" value="'.h($post['title']).'" /></p>');
		c(post_form(16,$post));
		c('
		<p>
						<label>'.t('Post options').'</label>
						<input type="checkbox" name="parseurl" value="1" checked />'.t('Automatically parse URLs').'<br />'
						.$subscribe.'
						'.url('forums/attachments/'.$post['id'], t('Manage attachments')).'
						</p>
		<input type="hidden" name="pid" value="'.$post['id'].'" />
		<input type="submit" class="button" value="'.t('Save changes').'" />
		</form>');
	}
	
	function editpostpost() {
		global $client;
		if (!$client['id']) {
			redirect('member/login/1');
		}
		if ($_POST['parseurl']) $_POST['form_content'] = parseurl($_POST['form_content']);
		$res = sql_query("select * from ".tb()."forum_posts where id='{$_POST['pid']}' ");
		$post = sql_fetch_array($res);
		if (!$post['id']) die('wrong pid');
		if ($post['uid'] != $client['id']) die('access denied');
		$thread = valid_thread($post['tid']);
		$set_post['id'] = $post['id'];
		$set_post['title'] = $_POST['title'];
		$set_post['message'] = $_POST['form_content'];
		check_post($set_post);
		sql_update($set_post, tb().'forum_posts');
		if ($post['is_first']) {
			$set_thread['id'] = $post['tid'];
			$set_thread['topic'] = $_POST['title'];
			check_thread($set_thread);
			sql_update($set_thread, tb().'forum_threads');
		}
		redirect(url('forums/viewthread/'.$post['tid']),1);
	}
	
	function deletepost($pid) {
		global $client;
		if (!$client['id']) {
			redirect('member/login/1');
		}
		$res = sql_query("select * from ".tb()."forum_posts where id='{$pid}' ");
		$post = sql_fetch_array($res);
		if (!$post['id']) die('wrong pid');
		if ($post['is_first']) die('you can not delete the primary post. To delete the thread instead');
		if ($post['uid'] != $client['id'] && !allow_access(3)) die('access denied');
		$thread = valid_thread($post['tid']);
		sql_query("delete from ".tb()."forum_posts where id='$pid' ");
		// delete attach
		$res = sql_query("select * from ".tb()."forum_attachments where pid='$pid' ");
		while ($attach = sql_fetch_array($res)) {
			sql_query("delete from ".tb()."forum_attachments where id='{$attach['id']}' ");
			unlink($attach['uri']);
		}
		// update num
		sql_query("update ".tb()."forum_threads set posts=posts-1 where id='{$thread['id']}' ");
		sql_query("update ".tb()."forums set posts=posts-1 where id='{$thread['fid']}' ");
		redirect(url('forums/viewthread/'.$post['tid']),1);
	}

	function attachments($pid) {
		GLOBAL $client;
		if (!$client['id']) {
			redirect('member/login/1');
		}
		$res = sql_query("select * from ".tb()."forum_posts where id='$pid' ");
		$post = sql_fetch_array($res);
		if (!$post['id']) die('wront pid');
		if ($post['uid'] != $client['id']) {
			die('not your post');
		}
		if (!$safe_community_posts = get_gvar('safe_community_posts')) {
			$safe_community_posts = 5;
		}
		if ($client['forum_posts'] < $safe_community_posts) {
			die('access denied');
		}
		$thread = valid_thread($post['tid']);
		$forum = valid_forum($thread['fid']);
		if (!forum_mod('',explode(',',$forum['moderators'])) ) {
			do_auth($forum['upload_roles']);
		}
		nav(url('forums/listthreads/'.$forum['id'],h($forum['name'])));
		nav(url('forums/viewthread/'.$thread['id'],h($thread['topic'])));
		// current files
		c('<table class="stories">
		<tr class="table_line1"><td colspan="2">'.t('Current files').'</td></tr>');
		$res = sql_query("select * from ".tb()."forum_attachments where pid={$pid}  order by id DESC");
		while ($row = sql_fetch_array($res)) {
			c('<tr class="row1"><td><a href="'.uhome().'/'.$row['uri'].'">'.h($row['orginal_name']).'</a> <span class="sub">('.h($row['des']).')</span></td><td>'.url('forums/attachment_delete/'.$row['id'],t('Delete')).'</td></tr>');
		}

		c('</table><br /><table class="stories">
		<tr class="table_line1"><td colspan="2">'.t('Upload').'</td></tr></table>');
		c('<form action="'.url('forums/attachmentspost').'" method="post" enctype="multipart/form-data">
						<p><label>'.t('File').'</label><input type="file" name="myfile" />
						<span>(jpg, png, gif, zip, rar, tar, gz)<br />
						Maximum:100k bytes</span></p>
						<p><label>'.t('Description').'</label><input type="text" name="description" size="45" />
						</p>
						<input type="submit" class="button" value="'.t('Submit').'" />
						<input type="hidden" name="pid" value="'.$pid.'" />
						 [ '.url('forums/viewthread/'.$thread['id'],h('Finish') ).' ]
				</form>');
	}

	function attachmentspost() {
		GLOBAL $db,$client,$ubase;
		if (!$client['id']) {
			redirect('member/login/1');
		}
		$timeline = time();
		$res = sql_query("select * from ".tb()."forum_posts where id='{$_POST['pid']}' ");
		$post = sql_fetch_array($res);
		if ($post['uid'] != $client['id']) {
			die('not your post');
		}
		$thread = valid_thread($post['tid']);
		$forum = valid_forum($thread['fid']);
		if (!forum_mod('',explode(',',$forum['moderators'])) ) {
			do_auth($forum['upload_roles']);
		}
		// up
		if ($uri = save_file($_FILES['myfile'],array('jpg','png','gif','zip','rar','tar','gz'))) {
			$size = $_FILES['myfile']['size'];
			if ($size > 100*1024) {
				sys_back('Sorry, you cannot upload a file larger than 100k');
			}
			$name = addslashes($_FILES['myfile']['name']);
			sql_query("insert into `".tb()."forum_attachments` (pid,uri,des,size,orginal_name,tid) values({$_POST['pid']},'$uri','".$_POST['description']."','$size','$name','{$post['tid']}')");
			$set_thread['id'] = $post['tid'];
			$set_thread['got_attach'] = 1;
			sql_update($set_thread, tb().'forum_threads');
			$set_post['id'] = $_POST['pid'];
			$set_post['got_attach'] = 1;
			sql_update($set_post, tb().'forum_posts');
			redirect($ubase.$this->name.'/attachments/'.$_POST['pid'], 1);
		}
		else {
			die('sorry,failed to upload pic');
		}
	}
	
	function attachment_delete($aid) {
		GLOBAL $db,$client,$ubase;
		if (!$client['id']) {
			redirect('member/login/1');
		}
		$timeline = time();
		$res = sql_query("select * from ".tb()."forum_attachments where id='{$aid}' ");
		$attach = sql_fetch_array($res);
		if (!$attach['id']) die('wrong aid');
		$res = sql_query("select * from ".tb()."forum_posts where id='{$attach['pid']}' ");
		$post = sql_fetch_array($res);
		if (!$post['id']) die('wrong pid from aid');
		if ($post['uid'] != $client['id']) {
			die('not your post');
		}
		// delete
		sql_query("delete from ".tb()."forum_attachments where id='$aid' ");
		unlink($attach['uri']);
		redirect(url('forums/attachments/'.$post['id']), 1);
	}
	
	function post_operations($post) {
		global $client;
		$output = '<div class="post_operations"><ul>
		<li>'.url('report',t('Report')).'</li>';
		if ($post['uid'] == $client['id'] || $client['level'] == 9)
		$output .= '<li>'.url('forums/editpost/'.$post['id'],t('Edit')).'</li>';
		if (allow_access(3))
			$output .= '<li>'.url('forums/deletepost/'.$post['id'],t('Delete')).'</li>';
		$output .= '<li>'.url('forums/newreply/'.$post['id'].'/quote',t('Quote')).'</li>
		<li>'.url('forums/newreply/'.$post['id'],t('Reply')).'</li>';
		
		if ($post['stream_id']) {
				//c(comment_form($post['stream_id'],'',1));
				$output .= forum_comment_form($post['stream_id']);
			}
		$output .= '
		</ul></div>';
		return $output;
	}
	
	function ajax_post() {
		global $client;
		if (!$client['id']) {
			die('please login');
		}
		if (!$_POST['thread_title'] || !$_POST['thread_content']) {
			forums::ajax_error(t('Please fill in all the required blanks'));
		}
		if (!$_POST['fid']) {
			forums::ajax_error(t('Please select a forum..'));
		}
		$forum = valid_forum($_POST['fid']);
		if (!forum_mod('',explode(',',$forum['moderators'])) ) {
			if (!allow_access($forum['thread_roles'])) {
				forums::ajax_error(t('Access denied'));
			}
		}
		$thread['topic'] = $_POST['thread_title'];
		$thread['fid'] = $_POST['fid'];
		$thread['username'] = $client['uname'];
		$thread['userid'] = $client['id'];
		$thread['icon'] = $_POST['icon'];
		$thread['posts'] = 1;
		$thread['lastpostusername'] = $client['uname'];
		$thread['created'] = time();
		$thread['lastpostcreated'] = time();
		$post['title'] = $_POST['thread_title'];
		if ($_POST['parseurl']) $_POST['thread_content'] = parseurl($_POST['thread_content']);
		$post['message'] = $_POST['thread_content'];
		limit_posting(0,1,'community_post');
		sql_insert($thread,tb().'forum_threads');
		$tid = insert_id();
		if ($_POST['subscribe']) {
			sql_insert(array('uid'=>$client['id'],'tid'=>$tid),tb()."forum_subscribes");
		}
		$post['tid'] = $tid;
		$post['is_first'] = 1;
		$post['uid'] = $client['id'];
		$post['created'] = time();
		sql_insert($post,tb().'forum_posts');
		$pid = insert_id();
		$set_thread['id'] = $tid;
		$set_thread['pid'] = $pid;
		sql_update($set_thread,tb().'forum_threads');
		$set_forum['id'] = $forum['id'];
		$set_forum['posts'] = $forum['posts'] + 1;
		$set_forum['threads'] = $forum['threads'] + 1;
		$set_forum['lastpostname'] = $client['uname'];
		$set_forum['lastpostcreated'] = time();
		$set_forum['lastposttopic'] = $_POST['thread_title'];
		$set_forum['lastposttopicid'] = $tid;
		sql_update($set_forum,tb().'forums');
		
		if (in_array(1,$forum['read_roles']) || in_array(2,$forum['read_roles'])) {
			$attachment = array(
					'cwall_id' => 'none',
					'uri' => 'forums/viewthread/'.$tid,
					'name' => h($_POST['thread_title'])
					);
			$app = array('name'=>'forums','id'=>$tid);
			$replyurl = url('forums/newreply/'.$pid,t('Reply'));
			$stream_id = stream_publish(
				addslashes(h(utf8_substr(stripslashes($_POST['thread_content']),120)).' '.$replyurl),
				$attachment,$app);
			sql_query("update ".tb()."forum_posts set stream_id='$stream_id' where id='$pid'");
				$return = parse_mentions($_POST['thread_content']);
				add_mentions($return['mentions'],$stream_id);
				sql_query("update ".tb()."accounts set forum_posts=forum_posts+1 where id='{$client['id']}'");
		}


		echo '<span style="background:yellow;color:black">'.t('Thread created!').'</span> <a href="'.url('forums/viewthread/'.$tid).'"><strong>'.t('View').'</strong></a><script>$("#form_submit").prop( "disabled", false );</script>';
		$_POST['thread_title'] = $_POST['thread_content'] = '';
		echo forums::ajax_form();
		exit;
	}

	function ajax_form($page_type='') {
		global $client;
		if (!$client) die('login');
		limit_posting(1,1,'community_post');
		$forums  = '<select name="fid">
		<option value="0">'.t('Please select a forum..').'</option>';
		/*
		$res = sql_query("select f.*,g.name as gname from ".tb()."forums as f left join ".tb()."forums as g on g.id=f.parent_id where f.forum_type='forum' order by f.parent_id");
		while ($row = sql_fetch_array($res)) {
			if ($row['id'] == $_POST['fid'])
				$row['selected'] = 'selected';
			$forums .= '<option value="'.$row['id'].'" '.$row['selected'].'>'.h($row['gname']).' - '.h($row['name']).'</option>';
		}
		$forums .= '</select>';
		*/
		$res = sql_query("select * from jcow_forums where forum_type='category' order by weight");
		while ($cat = sql_fetch_array($res)) {
			$forums .= '<optgroup label="'.h($cat['name']).'">';
			$res2 = sql_query("select * from jcow_forums where parent_id='{$cat['id']}' and forum_type='forum' order by weight");
			while ($row = sql_fetch_array($res2)) {
				$forums .= '<option value="'.$row['id'].'">'.h($row['name']).'</option>';
			}
			$forums .= '</optgroup>';
		}
		$forums .= '</select>';
		echo '
		<div>
';
if ($_POST['thread_title']) {
	$pre_title = h(stripslashes($_POST['thread_title']));
}
else {
	$pre_title = '';
}
echo '<div class="form-group">
		<input class="form-control" type="text" id="thread_title" name="thread_title" value="'.$pre_title.'" placeholder="'.t('Title').'"  />
	</div>
	<div class="form-group">
		<textarea name="thread_content" id="form_content" rows="7" class="form-control" placeholder="'.t('Content').'" >'.h(stripslashes($_POST['thread_content'])).'</textarea>
	</div>
	<div class="form-group">
	'.$forums.'</div>
		<script>
			$("#thread_title").focus();
		</script>
		';
		exit;
	}

	function ajax_error($msg) {
		echo '<div style="color:red">'.$msg.'</div><script>$("#form_submit").prop( "disabled", false );</script>';
		echo forums::ajax_form();
		exit;
	}
}

function valid_forum($fid) {
	if (is_numeric($fid) && $fid == 0) {
		if (!forum_mod()) die('Forum Recycle Bin: Access Denied');
		$forum = array('id'=>0,'name'=>t('Recyle Bin'));
		return $forum;
	}
	$res = sql_query("select * from ".tb()."forums where id='$fid' ");
	$forum = sql_fetch_array($res);
	$forum['read_roles'] = explode('|',$forum['read_roles']);
	$forum['upload_roles'] = explode('|',$forum['upload_roles']);
	$forum['thread_roles'] = explode('|',$forum['thread_roles']);
	$forum['reply_roles'] = explode('|',$forum['reply_roles']);
	if (!$forum['id']) die('wrong fid');
	return $forum;
}
function valid_thread($tid) {
	$res = sql_query("select * from ".tb()."forum_threads where id='$tid' ");
	$thread = sql_fetch_array($res);
	if (!$thread['id']) {
			redirect('forum',1);
		}
	return $thread;
}

function post_form($rows = 16, $post = array()) {
	$output = '
						<p>
						'.label(t('Message')).'
						<textarea name="form_content" rows="'.$rows.'" class="fpost"  style="width:90%" >'.h($post['message']).'</textarea>
						<span class="sub">'.t('Support Markdown format').' <a href="https://help.github.com/articles/markdown-basics/" target="_blank" >'.t('Help').'</a></span>
						';
	return $output;
}

function check_thread($thread) {
	if (strlen($thread['topic']) < 6)
		sys_back(t('The title is too short'));
}

function check_post($post) {
	if (strlen($post['message']) < 6)
		sys_back(t('The message is too short'));
}

function forum_mod($fid = '', $mods = 0) {
	global $client;
	if (!$client['id'])
		return false;
	if (in_array(3, $client['roles']))
		return true;
	if (!$fid && !count($mods))
		return false;
	if (!is_array($mods)) {
		$res = sql_query("select moderators from ".tb()."forums where id='$fid' ");
		$row = sql_fetch_array($res);
		if (strlen($row['moderators'])) {
			$mods = explode(',',$row['moderators']);
		}
		else {
			return false;
		}
	}
	if (in_array($client['username'], $mods))
		return true;
	else
		return false;
}


function forum_comment_form($stream_id) {
	global $config, $client;
	if (!$client['id']) {
		return '';
	}
	$res = sql_query("select * from ".tb()."streams where id='$stream_id'");
	$stream = sql_fetch_array($res);
	if (!$stream['id']) return '';
	if (!$flag) $flag = t('Comment');
	$likeit = '<span><li class="dolike"><a href="#">'.t('Like').'</a></li></span>';
	
	if ($stream['uid'] != $client['id']) {
		$res = sql_query("select * from ".tb()."liked where stream_id='$stream_id' and uid='{$client['id']}' limit 1");
		if (sql_counts($res)) {
			$likeit = '<span><li class="dolike"><a href="#">'.t('Unlike').'</a></li></span>';
		}
	}
	else {
		return '';
	}
		return '
		'.$likeit.'
			<div class="quick_comment_form" style="display:none;">
				<table border="0"><tr><td valign="top">
				<img src="'.uhome().'/'.uploads.'/avatars/s_'.$client['avatar'].'" width="25" height="25" />
				</td><td>
				<textarea name="message" rows="2" class="fpost commentmessage""  style="width:350px;" ></textarea>
				<input type="button" value=" '.$flag.' " class="fbutton commentsubmit" />
				</td></tr>
				</table>
			</div>
			<input type="hidden" name="wall_id" value="'.$stream_id.'" />
			<div style="padding-top:20px;text-align:right"></div>';
}

