<?php
class live
{
    function __construct()
    {
        need_login();
        $this->appID = get_gvar('agora_app_id');
        $this->appCertificate = get_gvar('agora_app_cert');
        set_title('Live');
    }
    function index()
    {
        global $client;
        if (!$this->appID || !$this->appCertificate) {
            c('empty appID and cerificate. If you are the admin, please go to adminCP->"Live Streaming settings" to setup.');
            stop_here();
        }
        c('<h2>Live rooms</h2>');
        if ($client['id']) {
            $res = sql_query("select * from jcow_live_rooms where uid='{$client['id']}' ");
            if (!sql_counts($res)) {
                c(button(['type' => 'link', 'title' => 'Start streaming', 'icon_name' => 'video-camera', 'uri' => 'live/create']));
            } else {
                c(row([
                    button(['type' => 'link', 'title' => 'Start streaming', 'icon_name' => 'video-camera', 'uri' => 'live/room/' . $client['username']]),
                    button(['type' => 'link', 'title' => 'Edit room', 'uri' => 'live/editroom/' . $client['username']]),
                ]));
            }
        }
        c('<div>');
        $timeline = time() - 20;
        $res = sql_query("select r.*,u.username,u.fullname,u.avatar from jcow_live_rooms as r left join jcow_accounts as u on u.id=r.uid where r.lastact>$timeline limit 50");
        while ($room = sql_fetch_array($res)) {
            c(
                row_center([
                    avatar($room), '<div><a href="' . url('live/room/' . $room['uri']) . '"><div style="background:red;display:inline-block;padding:0 5px;border-radius:5px;color:white">live</div> ' . h($room['name']) . '</a><br />' . h($room['fullname']) . '</div>'
                ])
            );
        }
        c('</div>');
    }

    function manage()
    {
        global $client;
        if (!allow_access(3)) {
            die('access denied');
        }
        c(
            'This live streaming need 3rd party api(Agora). <br />
            <b>How to get Agora app ID and cert</b>?<br />
            Go to <a href="https://www.agora.io/en/" target="_blank">Agora.io</a>, sign up an account. In it\'s console panel, click "project management", click "create a project", in the "use case" choose "video social". After the project created, you will see the app ID and Certificate.' .
                form(
                    [
                        input(['type' => 'text', 'label' => 'Agora app ID', 'name' => 'agora_app_id', 'value' => get_gvar('agora_app_id')]),
                        input(['type' => 'text', 'label' => 'Agora app Certificate', 'name' => 'agora_app_cert', 'value' => get_gvar('agora_app_cert')]),
                        input(['type' => 'submit', 'title' => 'Save changes'])
                    ],
                    ['action' => 'live/managepost']
                )
        );
    }
    function managepost()
    {
        set_gvar('agora_app_id', $_POST['agora_app_id']);
        set_gvar('agora_app_cert', $_POST['agora_app_cert']);
        form_go('live/manage', 1);
    }

    function create()
    {
        global $client;
        if (!$client) {
            die('please login');
        }
        c(
            form(
                [
                    input(['type' => 'name', 'label' => 'Room Name', 'name' => 'name']),
                    input(['type' => 'submit', 'title' => 'Create'])
                ],
                ['action' => 'live/createpost']
            )
        );
    }
    function createpost()
    {
        global $client;
        if (!$client) {
            die('please login');
        }
        $res = sql_query("select * from jcow_live_rooms where uid='{$client['id']}'");
        if (sql_counts($res)) {
            return_err('room exits');
        }
        if (!$_POST['name']) {
            return_err('no name');
        }
        sql_query("insert into jcow_live_rooms (name,uri,uid) values('{$_POST['name']}','{$client['username']}',{$client['id']})");
        form_go('live/room/' . $client['username']);
    }

    function room($uri)
    {
        global $client;
        need_login();
        $res = sql_query("select r.*,u.fullname,u.username,u.avatar from jcow_live_rooms as r left join jcow_accounts as u on u.id=r.uid where r.uri='$uri'");
        $room = sql_fetch_array($res);
        if ($room['lastact'] + 7 > time()) {
            $room['is_streaming'] = true;
        }
        if (!$room['id']) {
            return_err('room not found');
        }
        set_title(h($room['name']));
        $channelName = $room['uri'];
        //$channelName = 'test';
        $token = $this->get_token($channelName, $client['uid']);
        if ($room['uid'] == $client['id']) {
            if ($room['is_streaming']) { //view
                $role_btn = '<input type="hidden" id="current_role" value="audience" />';
                $player_box = '<div id="remote-playerlist" style="width:500px;height:400px;background:black"></div>';
            } else { // host
                $role_btn = '<input type="hidden" id="current_role" value="host" />';
                $player_box = '<div style="width:500px;height:400px;background:black"><div id="local-player" class="player"></div></div>';
            }
        } else {
            if ($room['is_streaming']) { // view
                $role_btn = '<input type="hidden" id="current_role" value="audience" />';
                $player_box = '<div id="remote-playerlist" style="width:500px;height:400px;background:black"></div>';
            } else {
                $player_box = '<div style="width:500px;height:400px;background:black;color:white;display:flex;align-items:center;justify-content:center">not streaming</div>';
            }
        }
        c('<div>
        ' . $role_btn . '
        <input type="hidden" id="live_channel" name="channel" value="' . $channelName . '" />
        <input type="hidden" id="live_uid" name="uid" value="' . $client['id'] . '" />
        <input type="hidden" id="live_appid" name="appid" value="' . $this->appID . '" />
        <input type="hidden" id="live_token" name="token" value="' . $token . '" />
        </div>');
        c('
        <div style="display:flex;flex-wrap: wrap;">
        <div  style="height:475px;width:500px">
        <div style="height:70px;display:flex;align-items:center">
            <div>' . avatar($room, 70) . '</div>
            <div style="display:flex;flex-direction:column">
                <div style="font-size:20px;font-weight:bold">' . h($room['name']) . '</div>
                <div>' . h($room['fullname']) . '</div>
            </div>
        </div>
          ' . $player_box . '
        </div>
        <div style="width: 330px;
        height: 475px;
        border: #999 1px solid;
        border-radius: 5px;
        margin-left: 10px;
        padding: 5px;display:flex;flex-direction:column">
            <div style="flex:1;display:flex;flex-direction:column-reverse;overflow-y:scroll" class="chat_messages"></div>
            <div style="height:30px;display:flex;gap:5px;align-items:center" class="live_chat_box">
                <input class="live_chat_input emoji_text" placeholder="send your message.." style="border:#ccc 1px solid;border-radius:5px;padding:3px" />
                <span class="emoji-trigger" style="cursor: pointer"><i class="fa fa-lg fa-smile-o"></i></span>
                <span class="live_chat_btn" style="cursor: pointer"><i class="fa fa-lg fa-send"></i></span>
                <input type="hidden" class="roomid" value="' . $room['id'] . '" />
            </div>
        </div>
        </div>
      ');
    }

    function editroom()
    {
        global $client;
        need_login();
        $res = sql_query("select * from jcow_live_rooms where uid='{$client['id']}'");
        $room = sql_fetch_array($res);
        if (!$room['id']) {
            return_err('room not found');
        }
        set_title(h($room['name']));
        c(
            form(
                [
                    input(['type' => 'name', 'label' => 'Room Name', 'name' => 'name', 'value' => $room['name']]),
                    input(['type' => 'submit', 'title' => 'Save'])
                ],
                ['action' => 'live/editpost']
            )
        );
    }
    function editpost()
    {
        global $client;
        if (!$client) {
            die('please login');
        }
        if (!$_POST['name']) {
            return_err('no name');
        }
        sql_query("update jcow_live_rooms set name='{$_POST['name']}' where uid='{$client['id']}'");
        form_go('live/room/' . $client['username']);
    }
    function sendmessage()
    {
        global $client;
        if (!$_POST['msg'] || !$_POST['roomid']) {
            die("empty");
        }
        $res = sql_query("select * from jcow_live_rooms where id='{$_POST['roomid']}'");
        $room = sql_fetch_array($res);
        if (!$room['id']) {
            die('room not found');
        }
        sql_query("insert into jcow_live_messages(uid,created,message,room_id) values('{$client['id']}'," . time() . ", '{$_POST['msg']}',{$room['id']})");
        die("sent");
    }
    function get_messages($roomid = 0)
    {
        global $client;
        if (!$roomid) {
            $roomid = $_POST['roomid'];
        }
        $res = sql_query("select * from jcow_live_rooms where id='{$roomid}'");
        $room = sql_fetch_array($res);
        if (!$room['id']) {
            return_err('room not found');
        }
        $res = sql_query("select m.*,u.fullname,u.username,u.avatar from jcow_live_messages as m left join jcow_accounts as u on u.id=m.uid order by m.id desc limit 50");
        $messages = [];
        while ($message = sql_fetch_array($res)) {
            $message['date'] = get_date($message['created']);
            $message['avatar'] = avatar($message, 'small');
            $messages[] = $message;
        }
        return_json(['status' => 'ok', 'messages' => $messages]);
        exit;
    }
    function update_live($roomid = 0)
    {
        global $client;
        if (!$roomid) {
            $roomid = $_POST['roomid'];
        }
        $res = sql_query("select * from jcow_live_rooms where id='{$roomid}'");
        $room = sql_fetch_array($res);
        if (!$room['id']) {
            return_err('room not found');
        }
        sql_query("update jcow_live_rooms set lastact=" . time() . " where id='{$roomid}'");
        echo 'updated';
        exit;
    }
    function get_token($channelName, $uid)
    {
        include("modules/live/AccessToken2.php");
        $uidStr = (string)$uid;
        $expireTimeInSeconds = 360;

        $accessToken = new AccessToken2($this->appID, $this->appCertificate, $expireTimeInSeconds);

        // grant rtc privileges
        $serviceRtc = new ServiceRtc($channelName, $uid);
        $serviceRtc->addPrivilege($serviceRtc::PRIVILEGE_JOIN_CHANNEL, $expireTimeInSeconds);
        $accessToken->addService($serviceRtc);

        // grant rtm privileges
        $serviceRtm = new ServiceRtm($uidStr);
        $serviceRtm->addPrivilege($serviceRtm::PRIVILEGE_LOGIN, $expireTimeInSeconds);
        $accessToken->addService($serviceRtm);

        // grant chat privileges
        $serviceChat = new ServiceChat($uidStr);
        $serviceChat->addPrivilege($serviceChat::PRIVILEGE_USER, $expireTimeInSeconds);
        $accessToken->addService($serviceChat);

        $token = $accessToken->build();
        return $token;
    }
    function default()
    {
        c(' <div class="container-fluid banner">
        <p class="banner-text">Basic Live</p>
        <a style="color: rgb(255, 255, 255);fill: rgb(255, 255, 255);fill-rule: evenodd; position: absolute; right: 10px; top: 4px;"
          class="Header-link " href="https://github.com/AgoraIO/API-Examples-Web/tree/main/Demo">
          <svg class="octicon octicon-mark-github v-align-middle" height="32" viewBox="0 0 16 16" version="1.1" width="32"
            aria-hidden="true">
            <path fill-rule="evenodd"
              d="M8 0C3.58 0 0 3.58 0 8c0 3.54 2.29 6.53 5.47 7.59.4.07.55-.17.55-.38 0-.19-.01-.82-.01-1.49-2.01.37-2.53-.49-2.69-.94-.09-.23-.48-.94-.82-1.13-.28-.15-.68-.52-.01-.53.63-.01 1.08.58 1.23.82.72 1.21 1.87.87 2.33.66.07-.52.28-.87.51-1.07-1.78-.2-3.64-.89-3.64-3.95 0-.87.31-1.59.82-2.15-.08-.2-.36-1.02.08-2.12 0 0 .67-.21 2.2.82.64-.18 1.32-.27 2-.27.68 0 1.36.09 2 .27 1.53-1.04 2.2-.82 2.2-.82.44 1.1.16 1.92.08 2.12.51.56.82 1.27.82 2.15 0 3.07-1.87 3.75-3.65 3.95.29.25.54.73.54 1.48 0 1.07-.01 1.93-.01 2.2 0 .21.15.46.55.38A8.013 8.013 0 0016 8c0-4.42-3.58-8-8-8z">
            </path>
          </svg>
        </a>
      </div>
    
      <div id="success-alert" class="alert alert-success alert-dismissible fade show" role="alert">
        <strong>Congratulations!</strong><span> You can invite others to watch your live by click </span><a href=""
          target="_blank">here</a>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
    
      <div class="container">
        <form id="join-form" name="join-form">
          <div class="row join-info-group">
          <div class="col-sm sso-hidden">
          <p class="join-info-text">AppID</p>
          <input id="appid" type="text" placeholder="enter appid" value="7ecb46f646e54807b2f283b56a0ded02">
          <p class="tips">If you don`t know what is your appid, checkout <a
              href="https://docs.agora.io/en/Agora%20Platform/terms?platform=All%20Platforms#a-nameappidaapp-id">this</a>
          </p>
        </div>
        <div class="col-sm sso-hidden">
          <p class="join-info-text">Token(optional)</p>
          <input id="token" type="text" placeholder="enter token" value="007eJxTYJjyYUZFiNenxfM2h22UnfVUNatryfLjHYeO2DHNn7C1fN8qBQbz1OQkE7M0MxOzVFMTCwPzJKM0IwvjJFOzRIOU1BQDIxaPOSkNgYwMpf9XMzEyQCCIz8JQklpcwsAAAAr4IdM=">
          <p class="tips">If you don`t know what is your token, checkout <a
              href="https://docs.agora.io/en/Agora%20Platform/terms?platform=All%20Platforms#a-namekeyadynamic-key">this</a>
          </p>
        </div>
        <div class="col-sm">
          <p class="join-info-text">Channel</p>
          <input id="channel" type="text" placeholder="enter channel name" value="test" required>
          <p class="tips">If you don`t know what is your channel, checkout <a
              href="https://docs.agora.io/en/Agora%20Platform/terms?platform=All%20Platforms#channel">this</a></p>
        </div>
        <div class="col-sm">
          <p class="join-info-text">User ID(optional)</p>
          <input id="uid" type="text" onkeyup="this.value=this.value.replace(/[^0-9]/g,\'\')"
            onafterpaste="this.value=this.value.replace(/[^0-9]/g,\'\')" placeholder="Enter the user ID">
        </div>
          </div>
    
          <div class="button-group">
            <button id="host-join" type="submit" class="btn btn-primary btn-sm">Join as host</button>
            <div class="btn-group">
              <button id="audience-join" type="button" class="btn btn-primary btn-sm" data-toggle="dropdown"
                aria-haspopup="true" aria-expanded="false">
                Join as audience
              </button>
              <div class="audience dropdown-menu">
                <button id="lowLatency" class="dropdown-item" label="Interactive Live Streaming Standard" >Interactive
                  Live Streaming Standard</button>
                <a id="ultraLowLatency" class="dropdown-item" label="Interactive Live Streaming Premium"
                  href="#">Interactive Live Streaming Premium</a>
              </div>
            </div>
            <button id="leave" type="button" class="btn btn-primary btn-sm" disabled>Leave</button>
          </div>
    
        </form>
        <!-- Single button -->
        <div class="row video-group">
          <div class="col">
            <p id="local-player-name" class="player-name"></p>
            <div id="local-player" class="player"></div>
          </div>
          <div class="w-100"></div>
          <div class="col">
            <div id="remote-playerlist"></div>
          </div>
        </div>
    
      </div>');
        stop_here();
    }
}
