// create Agora client
var client = AgoraRTC.createClient({
    mode: "live",
    codec: "vp8"
});
var localTracks = {
    videoTrack: null,
    audioTrack: null
};
var remoteUsers = {};
// Agora client options
var options = {
    appid: null,
    channel: null,
    uid: null,
    token: null,
    role: "audience",
    // host or audience
    audienceLatency: 2
};

var is_streaming = false

// the demo can auto join channel with params in url

async function start_host() {
    console.log('start_host');
    $(this).attr("disabled", true);
    try {
        options.role = "host";
        options.audienceLatency = 1;
        options.appid = $("#live_appid").val();
        options.channel = $("#live_channel").val();
        options.token = $("#live_token").val();
        options.uid = Number($("#live_uid").val());
        if (options.role == "host") {
            options.uid = options.uid + 100000
        }
        is_streaming = true
        await join();
    } catch (error) {
        console.error(error);
    } finally {
    }
}

async function start_view() {
    console.log('start_view');
    try {
        options.role = "audience";
        options.audienceLatency = 1;
        options.appid = $("#live_appid").val();
        options.channel = $("#live_channel").val();
        options.token = $("#live_token").val();
        options.uid = Number($("#live_uid").val());
        if (options.role == "host") {
            options.uid = options.uid + 100000
        }
        await join();
    } catch (error) {
        console.error(error);
    } finally {
    }
}

$(document).on("submit", "#join-form", async function (e) {
    e.preventDefault();
    $("#host-join").attr("disabled", true);
    $("#audience-join").attr("disabled", true);
    try {
        options.channel = $("#channel").val();
        options.uid = Number($("#uid").val());
        options.appid = $("#appid").val();
        options.token = $("#token").val();
        await join();
        if (options.role === "host") {
            $("#success-alert a").attr("href", `index.html?appid=${options.appid}&channel=${options.channel}&token=${options.token}`);
            if (options.token) {
                $("#success-alert-with-token").css("display", "block");
            } else {
                $("#success-alert a").attr("href", `index.html?appid=${options.appid}&channel=${options.channel}&token=${options.token}`);
                $("#success-alert").css("display", "block");
            }
        }
    } catch (error) {
        console.error(error);
    } finally {
        $("#leave").attr("disabled", false);
    }
});
$("#leave").click(function (e) {
    leave();
});
async function join() {
    // create Agora client

    if (options.role === "audience") {
        client.setClientRole(options.role, {
            level: options.audienceLatency
        });
        // add event listener to play remote tracks when remote user publishs.
        client.on("user-published", handleUserPublished);
        client.on("user-unpublished", handleUserUnpublished);
    } else {
        client.setClientRole(options.role);
    }

    // join the channel
    options.uid = await client.join(options.appid, options.channel, options.token || null, options.uid || null);
    if (options.role === "host") {
        // create local audio and video tracks
        if (!localTracks.audioTrack) {
            localTracks.audioTrack = await AgoraRTC.createMicrophoneAudioTrack({
                encoderConfig: "music_standard"
            });
        }
        if (!localTracks.videoTrack) {
            localTracks.videoTrack = await AgoraRTC.createCameraVideoTrack();
        }
        // play local video track
        localTracks.videoTrack.play("local-player");
        $("#local-player-name").text(`localTrack(${options.uid})`);
        $("#joined-setup").css("display", "flex");
        // publish local tracks to channel
        await client.publish(Object.values(localTracks));
        console.log("publish success");
    }
}
async function leave() {
    for (trackName in localTracks) {
        var track = localTracks[trackName];
        if (track) {
            track.stop();
            track.close();
            localTracks[trackName] = undefined;
        }
    }

    // remove remote users and player views
    remoteUsers = {};
    $("#remote-playerlist").html("");

    // leave the channel
    await client.leave();
    $("#local-player-name").text("");
    $("#host-join").attr("disabled", false);
    $("#audience-join").attr("disabled", false);
    $("#leave").attr("disabled", true);
    $("#joined-setup").css("display", "none");
    console.log("client leaves channel success");
}
async function subscribe(user, mediaType) {
    const uid = user.uid;
    // subscribe to a remote user
    await client.subscribe(user, mediaType);
    console.log("subscribe success");
    if (mediaType === 'video') {
        const player = $(`
        <div id="player-wrapper-${uid}">
          <p class="player-name">remoteUser(${uid})</p>
          <div id="player-${uid}" class="player"></div>
        </div>
      `);
        $("#remote-playerlist").append(player);
        user.videoTrack.play(`player-${uid}`, {
            fit: "contain"
        });
    }
    if (mediaType === 'audio') {
        user.audioTrack.play();
    }
}
function handleUserPublished(user, mediaType) {
    //print in the console log for debugging 
    console.log('"user-published" event for remote users is triggered.');
    const id = user.uid;
    remoteUsers[id] = user;
    subscribe(user, mediaType);
}
function handleUserUnpublished(user, mediaType) {
    //print in the console log for debugging 
    console.log('"user-unpublished" event for remote users is triggered.');
    if (mediaType === 'video') {
        const id = user.uid;
        delete remoteUsers[id];
        $(`#player-wrapper-${id}`).remove();
    }
}

$(document).on("click", ".live_chat_btn", function () {
    let live_chat_box = $(this).parent();
    let msg = live_chat_box.find(".live_chat_input");
    let roomid = live_chat_box.find(".roomid")
    if (msg.val()) {
        $.post($baseurl + "/index.php?p=live/sendmessage",
            { roomid: roomid.val(), msg: msg.val() },
            function (data) {
                if (data == 'sent') {
                    msg.val('')
                    update_message()
                }
            }, "html"
        );
    }
})

$(document).ready(function () {
    if ($("#current_role").val() == 'host') {
        start_host();
    }
    if ($("#current_role").val() == 'audience') {
        start_view();
    }
    update_message()
    setInterval(() => {
        update_message()
        update_act()
    }, 3000);
    $(".live_chat_input").on('keyup', function (e) {
        if (e.key === 'Enter' || e.keyCode === 13) {
            $(".live_chat_btn").click()
        }
    });
})
let messages = []
function update_message() {
    $.post($baseurl + "/index.php?p=live/get_messages",
        { roomid: $(".roomid").val() },
        function (data) {
            if (data.status == 'ok') {
                if (data.messages.length > messages.length) {
                    console.log('got new message');
                    messages = data.messages
                    let newHtml = ''
                    data.messages.map(m => {
                        newHtml += '<div>' + m.avatar + m.message + ' <span class="sub">' + m.date + '</span></div>';
                    })
                    $(".chat_messages").html(newHtml)
                }
            }
        }, "json"
    );
}


function update_act() {
    if (is_streaming) {
        $.post($baseurl + "/index.php?p=live/update_live",
            { roomid: $(".roomid").val() },
            function (data) {
                console.log(data)
            }, "html"
        );
    }
    else {
        console.log("not streaming")
    }
}
function set_is_streaming(status = true) {
    is_streaming = status
}