<?php

class minigames {

	var $games = [


'monkeykick' => ['url'=>'/webmasters/monkey-kick/en/', 'id'=>'monkey-kick','description'=>'Help Monkey Kick Furball to the hills and beyond! How far can you get?','title'=>'Embed Monkey Kick','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/monkey_150x110.jpg'],
'quickfirepoolinstant' => ['url'=>'/webmasters/quickfire-pool-instant/en/', 'id'=>'quickfire-pool-instant','description'=>'Pocket as many pool balls as you can before the time runs out!','title'=>'Embed Quick Fire Pool Instant','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/Instant_150.jpg'],
'shortride' => ['url'=>'/webmasters/short-ride/en/', 'id'=>'short-ride','description'=>'It\'s a Short Life! With so many dumb ways to die!','title'=>'Embed Short Ride','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/shortride_150x110.jpg'],
'bloxorz' => ['url'=>'/webmasters/bloxorz/en/', 'id'=>'bloxorz','description'=>'Get the block to fall into the square hole to progress to the next level…','title'=>'Embed Bloxorz','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/Bloxorz_150x110_anim_3.gif'],
'zomball' => ['url'=>'/webmasters/zomball/en/', 'id'=>'zomball','description'=>'Shoot your own body parts like basketballs!','title'=>'Embed Zomball','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/Zomball_150x110.jpg'],
'8ballpoolmultiplayer' => ['url'=>'/webmasters/8-ball-pool-multiplayer/en/', 'id'=>'8-ball-pool-multiplayer','description'=>'Play 8 Ball Pool against other players online!','title'=>'Embed 8 Ball Pool','image'=>'//static.miniclipcdn.com/content/game-icons/medium/8-Ball-Pool_26-02-2015.jpg'],
'zombiechoppa' => ['url'=>'/webmasters/zombie-choppa/en/', 'id'=>'zombie-choppa','description'=>'Get to the flares, rescue survivors and avoid the marauding zombies!','title'=>'Embed Zombie Choppa','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/zombiechoppa_150x110v2-min.png'],
'cartapult' => ['url'=>'/webmasters/cartapult/en/', 'id'=>'cartapult','description'=>'Cartapult your vehicles into the city for maximum mayhem and destruction!','title'=>'Embed Cartapult','image'=>'//static.miniclipcdn.com/content/game-icons/medium/cartapult_150x110.jpg'],
'sleighshot' => ['url'=>'/webmasters/sleigh-shot/en/', 'id'=>'sleigh-shot','description'=>'Summer is here, Santa is nowhere to be seen, but new contenders are now taking part in the Sleigh Shot challenge!  Now with added Multiplayer!','title'=>'Embed Sleigh Shot','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/SleighShot_150x110_icon.jpg'],
'battlegolfonline' => ['url'=>'/webmasters/battle-golf-online/en/', 'id'=>'battle-golf-online','description'=>'The hit mobile game, Battle Golf multiplayer!','title'=>'Embed Battle Golf Online','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/BGO_150x110_icon-min.jpg'],
'flipmaster' => ['url'=>'/webmasters/flip-master/en/', 'id'=>'flip-master','description'=>'Master the trampoline with Frontflips, Backflips, Gainers, Layouts, Jumps and Bounces on your backyard, gym or circus trampolines and train to be the Master of Trampoline!','title'=>'Embed Flip Master','image'=>'//static.miniclipcdn.com/content/game-icons/medium/MIN-Large_Icon_150x110.jpg'],
'twistedlines' => ['url'=>'/webmasters/twisted-lines/en/', 'id'=>'twisted-lines','description'=>'Cross the lines to swap colors and collect all hollow squares to solve the puzzle.','title'=>'Embed Twisted Lines','image'=>'//static.miniclipcdn.com/content/game-icons/medium/Twisted_150.jpg'],
'flipdiving' => ['url'=>'/webmasters/flip-diving/en/', 'id'=>'flip-diving','description'=>'Pull off Frontflips, Backflips & Gainers from high cliffs, rickety platforms, trees, castles, and trampolines! ','title'=>'Embed Flip Diving','image'=>'//static.miniclipcdn.com/content/game-icons/medium/flipdiving_150x110.jpg'],
'splixio' => ['url'=>'/webmasters/splixio/en/', 'id'=>'splixio','description'=>'In Splix.io you must conquer as much land as possible and try to become biggest Splix.io of all!','title'=>'Embed Splix.io','image'=>'//static.miniclipcdn.com/content/game-icons/medium/splixio_150x110.jpg'],
'cheapgolf' => ['url'=>'/webmasters/cheap-golf/en/', 'id'=>'cheap-golf','description'=>'A retromoderrn low-poly minigolf adventure hosted by the infamous AI bot SUSAN. ...Fling up and go FULL BOOP...','title'=>'Embed Cheap Golf','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/susan_150x110.jpg'],
'supersoccernoggins' => ['url'=>'/webmasters/super-soccer-noggins/en/', 'id'=>'super-soccer-noggins','description'=>'Pick your Super Soccer Noggin and Lead them to victory in various wacky tournaments!','title'=>'Embed Super Soccer Noggins','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/8_super_soccer_noggins_150x110.jpg'],
'rio2016olympicgames' => ['url'=>'/webmasters/rio-2016-olympic-games/en/', 'id'=>'rio-2016-olympic-games','description'=>'The Official Web game of the Rio 2016 Olympic Games!','title'=>'Embed Rio 2016 Olympic Games','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/Rio_icon_150x110.jpg'],
'eurosoccerforever' => ['url'=>'/webmasters/euro-soccer-forever/en/', 'id'=>'euro-soccer-forever','description'=>'Show off your free kick skills in Euro Soccer Forever!','title'=>'Embed Euro Soccer Forever','image'=>'//static.miniclipcdn.com/content/game-icons/medium/eurosoccerforever_150x110_variation1.png'],
'thunderbirds' => ['url'=>'/webmasters/thunderbirds/en/', 'id'=>'thunderbirds','description'=>'Join International Rescue on an amazing adventure full of action, hi-tech gadgets and the mighty Thunderbirds!','title'=>'Embed Thunderbirds Are Go: Team Rush','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/Thunderbirds_150x110_20160606.jpg'],
'basketballstars' => ['url'=>'/webmasters/basketball-stars/en/', 'id'=>'basketball-stars','description'=>'Show your skills, moves and fakes to juke out your opponent and shoot for the basket! ','title'=>'Embed Basketball Stars','image'=>'//static.miniclipcdn.com/content/game-icons/medium/BasketballStars_150_110.jpg'],
'agario' => ['url'=>'/webmasters/agar-io/en/', 'id'=>'agar-io','description'=>'The viral sensation! Eat cells smaller than you and don\'t get eaten by the bigger ones!','title'=>'Embed Agar.io','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/Agar.io_150x110_20150709.jpg'],
'stealthsniper2' => ['url'=>'/webmasters/stealth-sniper-2/en/', 'id'=>'stealth-sniper-2','description'=>'Headshot! Take out the bad guys, stealth-style!','title'=>'Embed Stealth Sniper 2','image'=>'//static.miniclipcdn.com/content/game-icons/medium/StealthSniper2_150x110.jpg'],
'pilotheroes' => ['url'=>'/webmasters/pilot-heroes/en/', 'id'=>'pilot-heroes','description'=>'Be a Pilot Hero and extinguish fires, avoid trees, chase other planes and a whole bunch of other missions!','title'=>'Embed Pilot Heroes','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/Pilot-Heroes_150x110.jpg'],
'cuttheropetimetravel' => ['url'=>'/webmasters/cut-the-rope-time-travel/en/', 'id'=>'cut-the-rope-time-travel','description'=>'Feed Om Nom with the candy that is out of his reach!','title'=>'Embed Cut the Rope Time Travel','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/ctr_tt_150x110.jpg'],
'footchinko' => ['url'=>'/webmasters/foot-chinko/en/', 'id'=>'foot-chinko','description'=>'Challenge your rivals in famous soccer tournaments.','title'=>'Embed Foot Chinko','image'=>'//static.miniclipcdn.com/content/game-icons/medium/FootChinko_150x110.jpg'],
'bowmasterhalloween' => ['url'=>'/webmasters/bow-master-halloween/en/', 'id'=>'bow-master-halloween','description'=>'Hunt wisps for Halloween!','title'=>'Embed Bow Master Halloween','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/bowmasterhalloween.jpg'],
'stealthsniper' => ['url'=>'/webmasters/stealth-sniper/en/', 'id'=>'stealth-sniper','description'=>'Take aim from the shadows','title'=>'Embed Stealth Sniper','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/stealthsniperv3.jpg'],
'cuttherope' => ['url'=>'/webmasters/cut-the-rope/en/', 'id'=>'cut-the-rope','description'=>'Feed Om Nom with the candy that is out of his reach!','title'=>'Embed Cut the Rope','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/cuttherope.jpg'],
'bananamania' => ['url'=>'/webmasters/banana-mania/en/', 'id'=>'banana-mania','description'=>'How skillful are you at throwing bananas?','title'=>'Embed Banana Mania','image'=>'//static.miniclipcdn.com/content/game-icons/medium/Bananamania_2_150x110.jpg'],
'manormonster' => ['url'=>'/webmasters/man-or-monster/en/', 'id'=>'man-or-monster','description'=>'Are you a man...or a monster?','title'=>'Embed Man or Monster','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/MoM.jpg'],
'sprintclubnitro' => ['url'=>'/webmasters/sprint-club-nitro/en/', 'id'=>'sprint-club-nitro','description'=>'Compete and win races to upgrade your car and become Sprint Club Nitro Champion!','title'=>'Embed Sprint Club Nitro','image'=>'//static.miniclipcdn.com/content/game-icons/medium/Sprint_Club_150x110.jpg'],
'totalwreckage' => ['url'=>'/webmasters/total-wreckage/en/', 'id'=>'total-wreckage','description'=>'Crash your way through a demolition derby!','title'=>'Embed Total Wreckage','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/totalwreckage.jpg'],
'turboracing3' => ['url'=>'/webmasters/turbo-racing-3/en/', 'id'=>'turbo-racing-3','description'=>'Burn rubber on the streets of Shanghai in Turbo Racing 3!','title'=>'Embed Turbo Racing 3','image'=>'//static.miniclipcdn.com/content/game-icons/medium/turboracing3.jpg'],
'saloonbrawl2' => ['url'=>'/webmasters/saloon-brawl-2/en/', 'id'=>'saloon-brawl-2','description'=>'Join the Wild West brawl and be the last one standing!','title'=>'Embed Saloon Brawl 2','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/saloonbrawl2.jpg'],
'aftersunset2' => ['url'=>'/webmasters/after-sunset-2/en/', 'id'=>'after-sunset-2','description'=>'Put them back in the ground!','title'=>'Embed After Sunset 2','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/aftersunset2christmas.jpg'],
'assaultcourse2' => ['url'=>'/webmasters/assault-course-2/en/', 'id'=>'assault-course-2','description'=>'Assault Course 2 is serious about teaching you the basics.','title'=>'Embed Assault Course 2','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/assaultcourse2.jpg'],
'freerunning2' => ['url'=>'/webmasters/free-running-2/en/', 'id'=>'free-running-2','description'=>'Defy gravity and risk virtual life and limb!','title'=>'Embed Free Running 2','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/freerunning2christmas.jpg'],
'bowmasterjapan' => ['url'=>'/webmasters/bow-master-japan/en/', 'id'=>'bow-master-japan','description'=>'','title'=>'Embed Bow Master Japan','image'=>'//static.miniclipcdn.com/content/game-icons/medium/bowmasterj2.jpg'],
'panikinchocoland' => ['url'=>'/webmasters/panik-in-chocoland/en/', 'id'=>'panik-in-chocoland','description'=>'Guide Panik through the factory collecting all the bombs.','title'=>'Embed Panik in Chocoland','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/PankiInChocolandnew.jpg'],
'rugbychallenge' => ['url'=>'/webmasters/rugby-challenge/en/', 'id'=>'rugby-challenge','description'=>'Convert all the tries.','title'=>'Embed Rugby Challenge','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/rugbychallenge.jpg'],
'dunebuggy' => ['url'=>'/webmasters/dune-buggy/en/', 'id'=>'dune-buggy','description'=>'Perform stunts to earn points!','title'=>'Embed Dune Buggy','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/dunebuggy.jpg'],
'gravityguy' => ['url'=>'/webmasters/gravity-guy/en/', 'id'=>'gravity-guy','description'=>'Gravity is your friend, let it help you to reach the end!','title'=>'Embed Gravity Guy','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/gg5_150.jpg'],
'monkeylander' => ['url'=>'/webmasters/monkey-lander/en/', 'id'=>'monkey-lander','description'=>'Collect all the bananas and land safely before your fuel runs out.','title'=>'Embed Monkey Lander','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/monkeylander.jpg'],
'candyandclyde' => ['url'=>'/webmasters/candy-and-clyde/en/', 'id'=>'candy-and-clyde','description'=>'Are you naughty or nice? The choice is yours.','title'=>'Embed Candy and Clyde','image'=>'//static.miniclipcdn.com/content/game-icons/medium/candyandclyde.jpg'],
'acidfactory' => ['url'=>'/webmasters/acid-factory/en/', 'id'=>'acid-factory','description'=>'Help Harry escape the horrors of his acid-flooded factory.','title'=>'Embed Acid Factory','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/AcidFactorynew.jpg'],
'alphattack' => ['url'=>'/webmasters/alphattack/en/', 'id'=>'alphattack','description'=>'Can you save the planet from the alpha bombs?','title'=>'Embed Alphattack','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/alphattack.jpg'],
'balance' => ['url'=>'/webmasters/balance/en/', 'id'=>'balance','description'=>'Grab your racquet and head to the courts. How long can you last?','title'=>'Embed Balance','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/balance.jpg'],
'bugonawire' => ['url'=>'/webmasters/bug-on-a-wire/en/', 'id'=>'bug-on-a-wire','description'=>'Can you guide your bug safely home and avoid getting eaten?','title'=>'Embed Bug On A Wire','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/bug.jpg'],
'canyondefense' => ['url'=>'/webmasters/canyon-defense/en/', 'id'=>'canyon-defense','description'=>'Build an ideal defense system and save the inhabitants.','title'=>'Embed Canyon Defense','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/canyondefense.jpg'],
'canyonglider' => ['url'=>'/webmasters/canyon-glider/en/', 'id'=>'canyon-glider','description'=>'Can you navigate the canyon and get the best score possible?','title'=>'Embed Canyon Glider','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/canyonglider.jpg'],
'caveofdespair' => ['url'=>'/webmasters/cave-of-despair/en/', 'id'=>'cave-of-despair','description'=>'Help Dr Carter beat the Lava and swing his way to safety.','title'=>'Embed Cave of Despair','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/caveofdespair.jpg'],
'commando' => ['url'=>'/webmasters/commando/en/', 'id'=>'commando','description'=>'Defend the Allies from the scourge of Europe.','title'=>'Embed Commando','image'=>'//static.miniclipcdn.com/content/game-icons/medium/Commandonew.jpg'],
'gyroball' => ['url'=>'/webmasters/gyroball/en/', 'id'=>'gyroball','description'=>'Navigate your gyroball to the glowing goal of each level.','title'=>'Embed Gyroball','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/gyroball.jpg'],
'silversphere' => ['url'=>'/webmasters/silversphere/en/', 'id'=>'silversphere','description'=>'Get the Silver Sphere in to the Blue Vortex.','title'=>'Embed Silversphere','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/silversphere.jpg'],
'zed' => ['url'=>'/webmasters/zed/en/', 'id'=>'zed','description'=>'Find enough gold to build a fine shiny space suit.','title'=>'Embed Zed','image'=>'//static.miniclipcdn.com/content/game-icons/medium/zed.jpg'],
'bloxforever' => ['url'=>'/webmasters/blox-forever/en/', 'id'=>'blox-forever','description'=>'Can you get your brain around matching all of the blox?','title'=>'Embed Blox Forever','image'=>'//static.miniclipcdn.com/content/game-icons/medium/bloxforever.jpg'],
'boomboomvolleyball' => ['url'=>'/webmasters/boom-boom-volleyball/en/', 'id'=>'boom-boom-volleyball','description'=>'Beach volleyball with an added BOOM!','title'=>'Embed Boom Boom Volleyball','image'=>'//static.miniclipcdn.com/content/game-icons/medium/boomboomvolleyball.jpg'],
'bushshootout' => ['url'=>'/webmasters/bush-shoot-out/en/', 'id'=>'bush-shoot-out','description'=>'Make sure that Bush and Condoleezza get out of the White House!','title'=>'Embed Bush Shoot-Out','image'=>'//static.miniclipcdn.com/content/game-icons/medium/bushshootoutgame.jpg'],
'cubebuster' => ['url'=>'/webmasters/cube-buster/en/', 'id'=>'cube-buster','description'=>'Clear the squares and become the quickest cube buster there is!','title'=>'Embed Cube Buster','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/cube.jpg'],
'cybermiceparty' => ['url'=>'/webmasters/cyber-mice-party/en/', 'id'=>'cyber-mice-party','description'=>'Rescue all the mice by showing them the way to the cheese.','title'=>'Embed Cyber Mice Party','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/cybermice.jpg'],
'danceplanet' => ['url'=>'/webmasters/dance-planet/en/', 'id'=>'dance-planet','description'=>'Tap the Space Bar at the right time to play the song notes.','title'=>'Embed Dance Planet','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/danceplanet.jpg'],
'dancingbush' => ['url'=>'/webmasters/dancing-bush/en/', 'id'=>'dancing-bush','description'=>'Make Bush dance the night away!','title'=>'Embed Dancing Bush','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/dancingbush.jpg'],
'deluxepool' => ['url'=>'/webmasters/deluxe-pool/en/', 'id'=>'deluxe-pool','description'=>'Use the pool cue to shoot and pocket the billiard balls.','title'=>'Embed Deluxe Pool','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/deluxepool.jpg'],
'fieldgoal' => ['url'=>'/webmasters/field-goal/en/', 'id'=>'field-goal','description'=>'Kick the ball through the goal posts to complete the levels.','title'=>'Embed Field Goal','image'=>'//static.miniclipcdn.com/content/game-icons/medium/field.jpg'],
'galacticwarrior' => ['url'=>'/webmasters/galactic-warrior/en/', 'id'=>'galactic-warrior','description'=>'Defeat the Aliens to get to the Galactic Big Boss.','title'=>'Embed Galactic Warrior','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/warrior.jpg'],
'golfish' => ['url'=>'/webmasters/golfish/en/', 'id'=>'golfish','description'=>'Complete this underwater course in the lowest number of shots.','title'=>'Embed Golfish','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/golfish.jpg'],
'penguinpush' => ['url'=>'/webmasters/penguin-push/en/', 'id'=>'penguin-push','description'=>'Push all the ice blocks into the yellow holes.','title'=>'Embed Penguin Push','image'=>'//static.miniclipcdn.com/content/game-icons/medium/penguinpush.jpg'],
'trapshoot' => ['url'=>'/webmasters/trapshoot/en/', 'id'=>'trapshoot','description'=>'Prove that you\'re the sharpest shooter.','title'=>'Embed Trapshoot','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/trapshoot.jpg'],
'3footninja' => ['url'=>'/webmasters/3-foot-ninja/en/', 'id'=>'3-foot-ninja','description'=>'Help little ninja defeat enemies and collect all the scrolls to move to the next level.','title'=>'Embed 3 Foot Ninja','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/3footninja.jpg'],
'3footninjaii' => ['url'=>'/webmasters/3-foot-ninja-ii/en/', 'id'=>'3-foot-ninja-ii','description'=>'The Princess has been kidnapped, defeat the evil minions to save her!','title'=>'Embed 3 Foot Ninja II','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/3footninja2.jpg'],
'cannonblast' => ['url'=>'/webmasters/cannon-blast/en/', 'id'=>'cannon-blast','description'=>'Blast all of the enemy boats into Davy Jones\' Locker.','title'=>'Embed Cannon Blast','image'=>'//static.miniclipcdn.com/content/game-icons/medium/cannon.jpg'],
'dancinghillary' => ['url'=>'/webmasters/dancing-hillary/en/', 'id'=>'dancing-hillary','description'=>'Check out Hillary\'s moves!','title'=>'Embed Dancing Hillary','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/dancinghillary.jpg'],
'detonator' => ['url'=>'/webmasters/detonator/en/', 'id'=>'detonator','description'=>'Help Walter defuse all the bombs.','title'=>'Embed Detonator','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/detonator.jpg'],
'gravity' => ['url'=>'/webmasters/gravity/en/', 'id'=>'gravity','description'=>'Guide your spaceship safely through all of the missions.','title'=>'Embed Gravity','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/gravity.jpg'],
'magicballs' => ['url'=>'/webmasters/magic-balls/en/', 'id'=>'magic-balls','description'=>'Group  two or more balls of the same color  to remove them.','title'=>'Embed Magic Balls','image'=>'//static.miniclipcdn.com/content/game-icons/medium/magic.jpg'],
'blairthemotivator' => ['url'=>'/webmasters/blair-the-motivator/en/', 'id'=>'blair-the-motivator','description'=>'Can you help Tony motivate the party into shape?','title'=>'Embed Blair The Motivator','image'=>'//static.miniclipcdn.com/content/game-icons/medium/blairthemotivator.jpg'],
'bushaerobics' => ['url'=>'/webmasters/bush-aerobics/en/', 'id'=>'bush-aerobics','description'=>'Help President Bush get fit and ready for his day.','title'=>'Embed Bush Aerobics','image'=>'//static.miniclipcdn.com/content/game-icons/medium/bushaerobics.jpg'],
'cablecapers2' => ['url'=>'/webmasters/cable-capers-2/en/', 'id'=>'cable-capers-2','description'=>'Can you help Arnold the Cable Fitter escape the underground maze?','title'=>'Embed Cable Capers 2','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/cablecapers2.jpg'],
'cheriediscoblair' => ['url'=>'/webmasters/cherie-disco-blair/en/', 'id'=>'cherie-disco-blair','description'=>'Make Cherie dance.','title'=>'Embed Cherie \'Disco\' Blair','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/cherie.jpg'],
'dancingblair' => ['url'=>'/webmasters/dancing-blair/en/', 'id'=>'dancing-blair','description'=>'Make Tony Blair dance like you have never seen him before.','title'=>'Embed Dancing Blair','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/blair.jpg'],
'shoppingmallparking' => ['url'=>'/webmasters/shopping-mall-parking/en/', 'id'=>'shopping-mall-parking','description'=>'Park the cars in the shopping mall car park.','title'=>'Embed Shopping Mall Parking','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/shoppingmallparking.jpg'],
'soccerstarsmobile' => ['url'=>'/webmasters/soccer-stars-mobile/en/', 'id'=>'soccer-stars-mobile','description'=>'Real-time online multiplayer game','title'=>'Embed Soccer Stars Mobile','image'=>'//static.miniclipcdn.com/content/game-icons/medium/SRS_Icon_150x110.png'],
'finalfortress' => ['url'=>'/webmasters/final-fortress/en/', 'id'=>'final-fortress','description'=>'The Ultimate end-of-the-world incremental clicker!','title'=>'Embed Final Fortress','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/FinalFortress_150x110.jpg'],
'tanxio' => ['url'=>'/webmasters/tanxio/en/', 'id'=>'tanxio','description'=>'Tanx is multiplayer tank battling like no other!','title'=>'Embed Tanx.io','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/Tanx_150x110.png'],
'brutalio' => ['url'=>'/webmasters/brutalio/en/', 'id'=>'brutalio','description'=>'The latest multi-player .io sensation, can you become King of the brutal.io Arena?','title'=>'Embed brutal.io','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/brutalio_150x110__20170411.png'],
'powerlineio' => ['url'=>'/webmasters/powerline-io/en/', 'id'=>'powerline-io','description'=>'Eat to grow, get close to others to boost your line but don\'t let your head touch the other powerlines. Play Powerline.io, it\'s electric!','title'=>'Embed Powerline.io','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/powerline_150x110.jpg'],
'worldsoccer2018' => ['url'=>'/webmasters/world-soccer-2018/en/', 'id'=>'world-soccer-2018','description'=>'Show off your free kick skills in World Soccer 2018!','title'=>'Embed World Soccer 2018','image'=>'//static3.miniclipcdn.com/content/game-icons/medium/worldsoccer2018_150x110.png'],
'soccersnakes' => ['url'=>'/webmasters/soccer-snakes/en/', 'id'=>'soccer-snakes','description'=>'Unleash the beasts! Soccer Snakes are battling it out in their own World Cup Tournament. ','title'=>'Embed Soccer Snakes','image'=>'//static.miniclipcdn.com/content/game-icons/medium/soccersnake_150x110.jpg'],
'holeio' => ['url'=>'/webmasters/hole-io/en/', 'id'=>'hole-io','description'=>'Hole.io, eat the world!','title'=>'Embed Hole.io','image'=>'//static2.miniclipcdn.com/content/game-icons/medium/hole-icon_150_110.jpg'],
	];
	function __construct() {
		clear_as();
		if ( $_SESSION['mobile_style'] ) {
			new_section('This module is only available on desktop.');
			render();
		}
	}

	function index() {
		global $page;
		$num_per_page = 20;
		$offset = ($page -1) * $num_per_page;
		$output = '<h1>Games</h1>';
		$game_listing = '<div style="display:flex;flex-wrap:wrap">';
		$i = $j = 0;
		foreach ($this->games as $key=>$game) {
			$game['key'] = $key;
			if ($i >= $offset) {
				$game['title'] = str_replace('Embed ','',$game['title']);
				if ($j > $num_per_page) {
					$got_next = true;
					$j--;
					break;
				}
				$j++;
				$game_listing .= minigame_preview_box($game);
			}
			$i++;
		}
		$game_listing .= '</div>';
		$output .= '<div>'.($offset+1).' - '.($offset+$j).' of <strong>'.count($this->games).'</strong> games</div>';
		$output .= $game_listing;
		$output .= pager($offset, $got_next, url('minigames'));
		new_section($output);

	}

	function play($game_id='') {
		if (!preg_match("/^[0-9a-z_\-]+$/i",$game_id)) {
			return_err('bad game id');
		}
		$game = $this->games[$game_id];
		if (!$game['id']) {
			return_err('game not found: '.$game_id);
		}
		$game['title'] = str_replace('Embed ','',$game['title']);
		set_title($game['title']);
		new_section('
<div style="display:flex;flex-direction:row;max-width:390px;margin:10px 0">
	<img src="https:'.$game['image'].'" style="width:75px;height:55px;border-radius:5px" />
	<div style="padding:0 10px">
		<strong>'.$game['title'].'</strong>
		<div style="font-size:0.9em">'.$game['description'].'</div>
	</div>
</div>
'.game_box($game['id']));
	}

}

function minigame_preview_box($game) {
	return '
<div style="display:flex;flex-direction:row;min-width:50%;max-width:390px;padding:20px 0">
	<div style="width:150px"><a href="'.url('minigames/play/'.$game['key']).'" style="display:block;width:150px"><img src="https:'.$game['image'].'" style="width:150px;height:110px;border-radius:5px" /></a></div>
	<div style="padding:0 10px">
		<strong>'.$game['title'].'</strong>
		<div style="font-size:0.9em">'.$game['description'].'</div>
		<div style="width:100px"><a href="'.url('minigames/play/'.$game['key']).'" class="btn btn-success btn-sm btn-block">'.t('Play').'</a></div>
	</div>
</div>
';
}

function game_box($game_id) {
	return '
<div class="miniclip-game-embed" data-game-name="'.$game_id.'" data-theme="5" data-width="800" data-height="800" data-language="en"><a href="https://www.miniclip.com/games/'.$game_id.'/">Play Monkey Kick</a></div>
<script src="//static.miniclipcdn.com/js/game-embed.js"></script>';
}